/* gasdf.h - header info for SDF functionality */
/* id: netcdf_io.h,v 1.2 1995/05/31 23:53:44 jac (Julia Collins) */
/* Revision 1.3 1997/07/21 09:51:00 hoop */
/* added gasdfparms struct */
/* Revision 1.2  1995/05/31  23:53:44  jac  */
/* add missing definition */
/*  */
/* Revision 1.1  1995/05/02  20:23:12  jac */
/* Initial revision */
/* */

typedef struct {
    int xsrch, ysrch, zsrch, tsrch ; /* if these need to be searched for */
    int dvsrch, isxdf ; /* do data var names need to be searched, is it xdf */
    int xsetup, ysetup, zsetup, tsetup ; /* if these need setting up */
    int needtitle, needundef ;
    char *xdimname, *ydimname, *zdimname, *tdimname ;
    int dvcount ; /* number of data variables */
    char **dvncnames, **dvganames ; /* netCDF datavar names, GrADS abbrevs */
    int *dvsetup ; /* does this var yet need its levelcnt and longname? */
    int hasDDFundef ;
} GASDFPARMS ;

#define CALENDAR "calendar"
#define CAL365 "365_day_year"
#define ALTCAL365 "noleap"

/*	=== Header file for File I/O ===	*/

#include "netcdf.h"
#include "udunits.h"

#define MISSING		-1

/* Missing data definitions  */
#define BFILL		FILL_BYTE
#define BMISS		-BFILL
#define SFILL		FILL_SHORT
#define SMISS		-SFILL
#define LFILL		FILL_LONG
#define LMISS		-LFILL
#define FFILL		FILL_FLOAT
#define FMISS		-FFILL		
#define DFILL		FILL_DOUBLE
#define DMISS		-DFILL

/* temporary flags to read time according to new or old standards */
#define CDC			0
#define COOP			1

/* default scale and offset values for unpacked files */
#define B_SCALE		(char) 	 1
#define S_SCALE		(short)  1
#define L_SCALE		(long) 	 1
#define F_SCALE		(float)  1.0
#define D_SCALE		(double) 1.0 
#define B_OFFSET	(char) 	 0
#define S_OFFSET	(short)  0
#define L_OFFSET	(long) 	 0
#define F_OFFSET	(float)  0.0
#define D_OFFSET	(double) 0.0 

/* Missing data definitions  */
#define BFILL		FILL_BYTE
#define BMISS		-BFILL
#define SFILL		FILL_SHORT
#define SMISS		-SFILL
#define LFILL		FILL_LONG
#define LMISS		-LFILL
#define FFILL		FILL_FLOAT
#define FMISS		-FFILL		
#define DFILL		FILL_DOUBLE
#define DMISS		-DFILL

/* structure to store data values */
union att_val {
  signed char  bval;
  short sval;
  long lval;
  float fval;
  double dval;
};

/* Attribute list. */
struct attrib_list {
	struct attrib_list *next;	/* pointer to next entry */
	char *name;			/* name of this attribute */
	nc_type type;			/* data type of this attribute */
	int len;			/* length of this attribute */
	void *data;			/* the data for this attribute */
};

/* generic structures for storing netcdf data.  	  */
typedef struct varinfo VAR_INFO;
struct varinfo
{
	VAR_INFO *next;	    		/* next variable structure, if       */
				    	/* >1 variable in the file.          */
	int varid;			/* Variable i.d. 		     */
	char varnam[MAX_NC_NAME + 1];	/* variable name 		     */
	char gradsabbr[16] ;            /* GrADS abbrev; comes in on i/o reqs*/
	nc_type vartype;		/* Variable data type. 		     */
	int nvardims;		    	/* Number of variable dimensions     */
	int vardimid[MAX_VAR_DIMS];	/* Variable dimension IDs. 	     */
					/* assumptions: the time dimension   */
					/* (if it exists) is first.  The     */
					/* dimension IDs may be used to index*/
					/* the IO_STD dimension arrays.      */
	int dimmap[4];/*-1s if not datavar; T{,Z},Y,X pos'ns (0..(nvardims-1))*/
        int dimidmap[4];/* see above, but dimids, not pos'ns */
	int nvatts;			/* Number of variable attributes     */
	struct attrib_list *first_vattr;/* First variable attribute. 	     */
	void *data;			/* actual data to be read from 	     */
					/* or written to the netCDF file     */
        union att_val missing_value ;   /* value of missing_value attribute */
};

typedef struct 
{
	int time_type;		/* temporary flag for time handling 	     */
	int cdfid;		/* netCDF File ID 	    	      	     */
	int ndims;		/* Number of dimensions in input file. 	     */
	int nvars;		/* Number of variables in input file. 	     */
	int ngatts;		/* Number of global attributes in input file.*/
	int dimids[MAX_NC_DIMS];/* list of all dimension IDs	 	     */
				/* dimension assumptions: if there is a time */
				/* dimension (which there should be, since   */
				/* the standard requires it :-) ), it is the */
				/* first dimension.  This array is redundant */
				/* since the dimensions are numbered sequen- */
				/* tially beginning with 0; thus the dimids  */
				/* ARE the array indices into this and the   */
				/* following two arrays.		     */
	char dimnam[MAX_NC_DIMS][MAX_NC_NAME + 1]; /* dimension names */
	long dimsiz[MAX_NC_DIMS]; /* dimension sizes		*/
	int recdim;		/* Unlimited (record) dimension */
	struct attrib_list *first_gattr;	/* First global attribute. */
	VAR_INFO *var;		/* variable information			*/
        int hasDDFundef ;       /* in DDF for xdfopen, UNDEF stmt occurred */
} IO_STD;
