/*  Copyright (C) 1988-2005 by Brian Doty and the Institute
                  of Global Environment and Society (IGES).  

    See file COPYRIGHT for more information.   */

#ifdef HAVE_CONFIG_H
#include <config.h>

/* If autoconfed, only include malloc.h when it's presen */
#ifdef HAVE_MALLOC_H
#include <malloc.h>
#endif

#else /* undef HAVE_CONFIG_H */

#include <malloc.h>

#endif /* HAVE_CONFIG_H */
#include <stdio.h>
#include <stdlib.h>
#include <math.h>

#define DRIVER_GAGMAP
#include "grads.h"
#include "gagmap.h"
#include "gx.h"

/*mf 961205 --- expose Mike Fiorino's global struct to these routines for 365 day calandars mf*/
extern struct gamfcmn mfcmn;
/*mf 961205 --- expose Mike Fiorino's global struct to these routines for 365 day calandars mf*/

int help=0;
void command_line_help(void) ;

main (int argc, char *argv[]) {


/* ---------------- command line processing   ------------------- */

/*---
  defaults
---*/

  skip=0;
  verb=0;         /* verbose default is NO */
  quiet=0;        /* quiet mode default is NO */
  ver=2;          /* default version */
  scaneof=0;      /* option to ignore failure to find data at end of file */
  scanEOF=0;      /* option to ignore failure to find data at end of file */
  scanlim=1000;   /* the default # of max bytes between records */
  notau=0;        /* force time to be base time */
  tauave=0;       /* use end time (default) for averaged products vs. start time */
  tauflg=0;       /* search for a fixed tau in filling the 4-D volume */
  tauoff=0;       /* the fixed tau in h */
  tau0=0;         /* set the base dtg for tau search */
  forceok=0;      /* continue after errors */
  update=0;       /* set the base dtg for tau search */
  write_map=1;    /* write out the map (testing only) */
  diag=0;         /* full diagnostics */
  mpiflg=0;
  ifile = NULL;
  no_min=0;	  /* keep minutes code */

  mfcmn.fullyear=1; /* initialize the GrADS calendar so it is set to the file calendar in gaddes */

  if (argc>1) {
    iarg = 1;
    while (iarg<argc) {
      flg = 1;
      ch = argv[iarg];
      if (*ch=='-' && *(ch+1)=='m') {  /* Not sure I like this */
        mpiflg = 1;
        flg = 0;
      }
      if (*ch=='-' && *(ch+1)=='i') {
        iarg++;
        if (iarg<argc) {
          ifile = argv[iarg];
          flg = 0;
        } else iarg--;   /* Let error message pop */
      }
      else if (*ch=='-' && *(ch+1)=='0') {
        notau = 1;
	flg = 0;
      }
      else if (*ch=='-' && *(ch+1)=='e') {
        scaneof = 1;
	flg = 0;
      }
      else if (*ch=='-' && *(ch+1)=='E') {
        scanEOF = 1;
	flg = 0;
      }
      else if (*ch=='-' && *(ch+1)=='1') {
        ver = 1;
	flg = 0;
      }
      else if (*ch=='-' && *(ch+1)=='2') {
        ver = 2;
	flg = 0;
      }
      else if (*ch=='-' && *(ch+1)=='u') {
        update = 1;
	flg = 0;
      }
      else if (*ch=='-' && *(ch+1)=='k') {
        forceok = 1;
	flg = 0;
      }
      else if (*ch=='-' && *(ch+1)=='N') {
        write_map=0;
	flg = 0;
      }
      else if (*ch=='-' && *(ch+1)=='h' && *(ch+2)=='e' && *(ch+3)=='l' && *(ch+4)=='p' ) {
        help=1;
	flg = 0;
      }
      else if (*ch=='-' && *(ch+1)=='b') {
        tauave=1;
	flg = 0;
      }
      else if (*ch=='-' && *(ch+1)=='d') {
        diag=1;
	flg = 0;
      }
      else if (*ch=='-' && *(ch+1)=='s') {
        scanflg = 1;
        ch+=2;
        i = 0;
        while(*(ch+i) && i<900) {
          if (*(ch+i)<'0' || *(ch+i)>'9') i = 999;
          i++;
        }
        if (i<900) {
          sscanf(ch,"%i",&scanlim);
          flg = 0;
        }
      }
      else if (*ch=='-' && *(ch+1)=='f') {
        tauflg = 1;
        ch+=2;
        i = 0;
        while(*(ch+i) && i<900) {
          if (*(ch+i)<'0' || *(ch+i)>'9') i = 999;
          i++;
        }
        if (i<900) {
          sscanf(ch,"%i",&tauoff);
          flg = 0;
        }
      }
      else if (*ch=='-' && *(ch+1)=='t' && *(ch+2)=='0') {
        tau0=1;
        flg = 0;
      }
      else if (*ch=='-' && *(ch+1)=='v') {
        if(!quiet) verb=1;
        flg = 0;
      }
      else if (*ch=='-' && *(ch+1)=='q') {
        quiet=1;
	verb=0;
        flg = 0;
      }
      else if (*ch=='-' && *(ch+1)=='m' && *(ch+2)=='i' && *(ch+3)=='n' && *(ch+4)=='0' ) {
        no_min = 1;
        flg = 0;
      }
      else if (*ch=='-' && *(ch+1)=='h') {
        ch+=2;
        if (*ch=='n' && *(ch+1)=='m' &&  *(ch+2)=='c') {
          skip = -1;
          flg = 0;
        }
        else {
          i = 0;
          while(*(ch+i) && i<900) {
            if (*(ch+i)<'0' || *(ch+i)>'9') i = 999;
            i++;
          }
          if (i<900) {
            sscanf(ch,"%i",&skip);
            flg = 0;
          }
        }
      }
      if (flg) {
        printf ("Invalid command line argument: %s  Ignored.\n",argv[iarg]);
      }
      iarg++;
    }

  } else {

    command_line_help();

  }

  if(help) {
    command_line_help();
    return(0);
  }

  mfcmn.cal365=-1; /* initialize the GrADS calendar so it is set to the file calendar in gaddes */
  rc=gribmap();
  
  mfcmn.cal360=1; /* initialize the GrADS calendar so it is set to the file calendar in gaddes */
  rc=gribmap();

}


void command_line_help(void) {
/*---
  output command line options
---*/

printf("gribmap v1.4 for GrADS Version " GRADS_VERSION "\n");
printf("creates the \"map\" file for using GRIB data in grads\n\n");
printf("Command line options: \n\n");
printf("   -help     prints out this help\n");
printf("   -i fname  provides the name of data descriptor file to map\n");
printf("   -v        verbose option shows details of the mapping\n");
printf("   -q        quiet mode gives no listing except for errors\n");
printf("   -hNNNN    where NNNN is the # of header bytes to look for first GRIB messages (default is 100)\n");
printf("   -sNNNN    where NNNN is the maximum # of bytes to skip between GRIB messages (default is 1000)\n");
printf("   -u        updates existing gribmap if templated data (options template in the .ctl file)\n");
printf("   -1        creates a machine specific version 1 map \n");
printf("   -2        creates a machine-INDEPENDENT version 2 map (the default for " GRADS_VERSION " and above\n");
printf("   -0        ignores the forecast time in the mapping; only uses the base time\n");
printf("   -t0       force match if base time in the GRIB message is the same as base time in the .ctl file\n");
printf("   -fNNNN    force match for forecast time in hours = NNNNN (e.g., f24 for t=24 h)\n");
printf("   -min0     ignore minutes code \n");
printf("   -e        ignore junk bytes (non GRIB msg) at end of file (e.g., ECMWF GRIB because of blocking)\n");
printf("   -E        ignore junk bytes in middle and/or end of GRIB file\n");
printf("   -N        do NOT write the map \n");
printf("   -m        SPECIAL OPTION for MPI \n");
printf("   -hnmc     SPECIAL OPTION for NCEP (before the name change from NMC) \n");
printf("   -b        set the valid time for averages to be the beginning of the period rather than the end (default)\n\n");
printf("   Example:\n");
printf("   gribmap -e -i mygrib.ctl\n\n");
printf("   creates a map file (specified by the index line in mygrib.ctl) but ignore junk at end\n");

}

void gaprnt (int i, char *ch) {
  printf ("%s",ch);
}

/* Query env symbol */

char *gxgsym(char *ch) {
  return (getenv(ch));
}
