
/* 
 * Include ./configure's header file
 */
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif


/* Rasterize current metafile buffer via gd library.  Loosly based
   on the gxpng utility:

   gxpng Copyright 1999 Matthias Muennich 

   Has been modified to behave more like the X interface, so the
   output image will look more like the screen image. */

#include "gd.h"

int gxhpng (char *, int, int, int, int, char *, char *, int) ;

void gdImageFilldPolygon(gdImagePtr im, gdPointPtr p, int n, int c);
void gdImageLne(gdImagePtr im, int x1, int y1, int x2, int y2, int color); 
   
/* default size of the graph */

#define SX 800
#define SY 600

static char pout[256];   /* Build error msgs here */

/* rgb values for 16 defined colors */
/* these exactly match what's in gxX.c so that the graphical display 
   and the printim output look the same */
static int 
 rr[16]={0,255,250,  0, 30,  0,240,230,240,160,160,  0,230,  0,130,170},
 gg[16]={0,255, 60,220, 60,200,  0,220,130,  0,230,160,175,210,  0,170},
 bb[16]={0,255, 60,  0,255,200,130, 50, 40,200, 50,255, 45,140,220,170};

int gxhpng (char *fnout, int xin, int yin, int bwin, int gifflg, 
	    char *bgImage, char *fgImage, int tcolor) {
FILE *ofile, *bgfile, *fgfile;
gdPoint *xybuf;
gdImagePtr im=NULL, imfg, imbg;
float xlo,xhi,ylo,yhi;
int xpos,ypos,xs,ys,xrs,yrs;
int cmd,i,j,cnt,flag,ii,siz,xp,yp,xp2,yp2,thck,h,w,backbw;
int ccol,lwide,fflag,xyc,red,grn,blu,xcur,ycur,xsav,ysav,retcod;
int cdef[100],cnum[100],rc[100],gc[100],bc[100];
short *poi,*pend;
 int len;
  if (bwin<-900) backbw = gxdbkq();
  else backbw = bwin;

  for (i=0; i<100; i++) {
    cdef[i]=0;
    rc[i] = 125; gc[i] = 125; bc[i] = 125;
  }
  for (i=0; i<16; i++) { 
    rc[i] = rr[i]; gc[i] = gg[i]; bc[i] = bb[i];
  }

  /*  Set up pointers into current meta buffer list */

  if (dbmode && pntf==0) {
    lens2[pnt2-1] = hpnt-hbuff;
    cnt = pnt2; flag = 1;
  } else {
    lens[pnt-1] = hpnt-hbuff;
    cnt = pnt; flag = 0;
  }

  /*  Allocate the gd image and set up the scaling for it */

  if (xin<0 || yin<0) {
    if (xrsize > yrsize) {xs = SX; ys = SY;}
    else {xs = SY; ys = SX;}
  } else {xs = xin; ys = yin;}
  xrs = (int)(xrsize*1000.0+0.5);
  yrs = (int)(yrsize*1000.0+0.5);

  /* handle background PNG picture */
  if(*bgImage) {
    /* Make sure bgImage is a .png -- otherwise return error */
    len = 0;
    while (*(bgImage+len)) len++;
    len = len-4;
    if (len>0) {
      if (*(bgImage+len+1)!='p' || 
	  *(bgImage+len+2)!='n' || 
	  *(bgImage+len+3)!='g' ) {
	if (*(bgImage+len+1)!='P' || 
	    *(bgImage+len+2)!='N' || 
	    *(bgImage+len+3)!='G' ) {
	  return(5);
	} 
      }
    }

    if(bgfile=fopen(bgImage,"rb")) {
      if((im=gdImageCreateFromPng(bgfile)) != NULL) {
	if (im->sx < xs || im->sy < ys) {
	  gdImageDestroy(im);
	  im=NULL;
	}
      } else {
	fclose(bgfile);
	return(7);
      }
      fclose(bgfile);
    } else {
      return(3);
    }
  }
    
  if (!im) {
    im = gdImageCreate(xs,ys);
  }

  /*  Set up background and foreground colors */
  if (backbw) {
    cnum[0] = gdImageColorAllocate(im, 255, 255, 255);
    cnum[1] = gdImageColorAllocate(im, 0, 0, 0);
  } else {
    cnum[0] = gdImageColorAllocate(im, 0, 0, 0);
    cnum[1] = gdImageColorAllocate(im, 255, 255, 255);
  }
  cdef[0] = 1; cdef[1] = 1;
  ccol = 1;
       
  /* Loop thru allocated meta buffers and handle the graphics commands found there */
  fflag = 0;
  for (ii=0; ii<cnt; ii++) {
    if (flag) {
      poi = bufs2[ii];
      pend = poi + lens2[ii];
    } else { 
      poi = bufs[ii];
      pend = poi + lens[ii];
    } 
    
    while (poi<pend) {
      /* Get message type */
      cmd = *poi; 

      /* Handle various message types */
      /* -9 is end of file.  Should not happen. */
      if (cmd==-9) {
        gaprnt(0,"Logic Error 4 in gxhpng.  Notify Developer\n");
        return(99);
      }

      /*  -1 indicates start of file.  Should not ocurr. */
      else if (cmd==-1) {
        gaprnt(0,"Logic Error 8 in gxhpng.  Notify Developer\n");
        return(99);
      }
  
      /* -2 indicates new frame.  Also should not ocurr */
      else if (cmd==-2) {
        gaprnt(0,"Logic Error 12 in gxhpng.  Notify Developer\n");
        return(99);
      }

      /* -3 indicates new color.  One arg; color number.  */
      /*  Allocate in gd if not done already */
      else if (cmd==-3) {
        ccol = *(poi+1);
        if (ccol<0) ccol=0;
        if (cdef[ccol]==0) {
          cnum[ccol] = gdImageColorAllocate(im, rc[ccol], gc[ccol], bc[ccol]);
          cdef[ccol] = 1;
        }
        poi += 2;
      }

      /* -4 indicates new line thickness.  It has two arguments */
      else if (cmd==-4) {
        thck = *(poi+2);
        poi += 3;
      }

      /*  -5 defines a new color, in rgb.  It has four int args */
      /*  If this changes the existing definition for this color, 
          then indicate this has not yet been allocated to gd */
      else if (cmd==-5){
        i = *(poi+1);
        red = *(poi+2);
        grn = *(poi+3);
        blu = *(poi+4);
        if (rc[i]!=red || gc[i]!=grn || bc[i]!=blu) {
          rc[i] = red; gc[i] = grn; bc[i] = blu;
          cdef[i] = 0;
        }
        poi += 5;
      }

      /* -6 is for a filled rectangle.  It has four float args. */ 
      else if (cmd==-6){
        xlo = *(poi+1); ylo = *(poi+3);
        xhi = *(poi+2); yhi = *(poi+4);
        xp = (xlo*xs)/xrs;
        yp = ys-(ylo*ys)/yrs;
        xp2 = (xhi*xs)/xrs;
        yp2 = ys-(yhi*ys)/yrs;
        if (xp>xp2) { 
           i = xp;
           xp = xp2;
           xp2 = i;
        }
        if (yp>yp2) { 
           i = yp;
           yp = yp2;
           yp2 = i;
        }
        gdImageFilledRectangle(im, xp, yp, xp2, yp2, cnum[ccol]);
        poi += 5;
      }

      /* -7 indicates the start of a polygon fill.  It has one arg. */
      else if (cmd==-7){
        siz = *(poi+1);
        xybuf = (gdPoint *)malloc(sizeof(gdPoint)*(siz+1));
        if (xybuf==NULL) {
          gaprnt(0,"Memory allocation error: gxhpng\n");
          return(99);
        }
        fflag = 1;
        xyc = 0;
        poi += 2;
      }

      /* -8 is to terminate polygon fill.  It has no args */
      else if (cmd==-8) {
        if (xybuf->x != (xybuf+xyc-1)->x ||
            xybuf->y != (xybuf+xyc-1)->y) {
          (xybuf+xyc)->x = xybuf->x;
          (xybuf+xyc)->y = xybuf->y;
          xyc++;
        }
        gdImageFilldPolygon(im, xybuf, xyc, cnum[ccol]); 
        free (xybuf);
        fflag = 0;
        poi += 1;
      }

      /* -10 is a move to instruction.  It has two float args */ 
      else if (cmd==-10){
        xpos = *(poi+1); ypos = *(poi+2);
        xsav = (xpos*xs)/xrs;
        ysav = ys-(ypos*ys)/yrs;
        if (fflag) {
          (xybuf+xyc)->x = xsav;
          (xybuf+xyc)->y = ysav;
          xyc++;
        }   
        poi += 3;
      }

      /*  -11 is draw to.  It has two float args. */  
      else if (cmd==-11){
        xpos = *(poi+1); ypos = *(poi+2);
        xcur = (xpos*xs)/xrs;
        ycur = ys-(ypos*ys)/yrs;
        if (fflag) {    /* Assume first poly point is moveto */
          if ((xybuf+xyc-1)->x != xcur || (xybuf+xyc-1)->y != ycur) { 
            (xybuf+xyc)->x = xcur;
            (xybuf+xyc)->y = ycur;
            xyc++;
          }
        } else {
          gdImageLne(im, xsav, ysav, xcur, ycur, cnum[ccol]);
          if (thck>5) {           /* if wide thcknss, draw extra lines */
            w = xsav - xcur;
            if (w<0) w = -1*w;
            h = ysav - ycur;
            if (h<0) h = -1*h;
            if (w<h) {
              gdImageLne(im, xsav-1, ysav, xcur-1, ycur, cnum[ccol]);
              if (thck>11) gdImageLne(im, xsav+1, ysav, xcur+1, ycur, cnum[ccol]);
            } else {
              gdImageLne(im, xsav, ysav-1, xcur, ycur-1, cnum[ccol]);
              if (thck>11) gdImageLne(im, xsav, ysav+1, xcur, ycur+1, cnum[ccol]);
            }
          }
        }
        xsav = xcur; ysav = ycur;
        poi += 3;
      }

      /* -12 indicates new fill pattern.  We ignore it here */
      else if (cmd==-12) {
        poi += 4;
      }

      /* -20 is a draw widget.  We ignore it here. */
      else if (cmd==-20) {
        poi += 2;
      }

      /* Any other command would be invalid */
      else {
        gaprnt(0,"Logic Error 20 in gxhpng.  Notify Developer\n");
        return(99);
      }
    }
  }

  /* handle foreground PNG picture */
  if(*fgImage) {
    /* Make sure fgImage is a .png -- otherwise return error */
    len = 0;
    while (*(fgImage+len)) len++;
    len = len-4;
    if (len>0) {
      if (*(fgImage+len+1)!='p' || 
	  *(fgImage+len+2)!='n' || 
	  *(fgImage+len+3)!='g' ) {
	if (*(fgImage+len+1)!='P' || 
	    *(fgImage+len+2)!='N' || 
	    *(fgImage+len+3)!='G' ) {
	  return(6);
	} 
      }
    }

    if(fgfile=fopen(fgImage,"rb")) {
      if((imfg=gdImageCreateFromPng(fgfile)) !=NULL) {
	gdImageCopy(im,imfg,0,0,0,0,imfg->sx,imfg->sy);
      }
      else {
	fclose(fgfile);
	return(8);
      }
    } else {
      return(4);
    }
    fclose(fgfile);
    gdImageDestroy(imfg);
  }
  

  retcod = 0;
  /* optionally convert a color to transparent */
  if(tcolor != -1 ) {
    if(cdef[tcolor]){
      gdImageColorTransparent(im,cnum[tcolor]);
      sprintf(pout,"Transparent color: #%d\n",tcolor);
      gaprnt(2,pout);
    }
  }
  if(*bgImage) {
    if(bgfile=fopen(bgImage,"rb")) {
      if((imbg=gdImageCreateFromPng(bgfile)) !=NULL) {
	gdImageCopy(imbg,im,0,0,0,0,im->sx,im->sy);
      }
    }
    fclose(bgfile);
    gdImageDestroy(im);
    im=imbg;
  }

  ofile = fopen(fnout, "wb");
  if (ofile==NULL) { 
    sprintf(pout,"Open error on %s\n",fnout);
    gaprnt(0,pout);
    retcod = 1; 
  } else {
    if (gifflg) gdImageGif(im, ofile);
#ifdef GXJPEG
    else if (gifflg==3) gdImageJpeg(im, ofile,-1);
#endif
    else gdImagePng(im, ofile);
    fclose(ofile);
  }
  gdImageDestroy(im);
  return (retcod);
}
	
int gdCompareInt(const void *a, const void *b);

/* Version of gdImageFilledPolygon to invoke my local 
   version of gdImageLne.  Nothing else changed... B.Doty 5/31/01 */

/* THANKS to Kirsten Schulz for the polygon fixes! */

/* The intersection finding technique of this code could be improved  */
/* by remembering the previous intertersection, and by using the slope.*/
/* That could help to adjust intersections  to produce a nice */
/* interior_extrema. */

void gdImageFilldPolygon(gdImagePtr im, gdPointPtr p, int n, int c)
{
	int i;
	int y;
	int miny, maxy;
	int x1, y1;
	int x2, y2;
	int ind1, ind2;
	int ints;
	if (!n) {
		return;
	}
	if (!im->polyAllocated) {
		im->polyInts = (int *) malloc(sizeof(int) * n);
		im->polyAllocated = n;
	}		
	if (im->polyAllocated < n) {
		while (im->polyAllocated < n) {
			im->polyAllocated *= 2;
		}	
		im->polyInts = (int *) realloc(im->polyInts,
			sizeof(int) * im->polyAllocated);
	}
	miny = p[0].y;
	maxy = p[0].y;
	for (i=1; (i < n); i++) {
		if (p[i].y < miny) {
			miny = p[i].y;
		}
		if (p[i].y > maxy) {
			maxy = p[i].y;
		}
	}
	/* Fix in 1.3: count a vertex only once */
	for (y=miny; (y <= maxy); y++) {
/*1.4		int interLast = 0; */
/*		int dirLast = 0; */
/*		int interFirst = 1; */
		ints = 0;
		for (i=0; (i < n); i++) {
			if (!i) {
				ind1 = n-1;
				ind2 = 0;
			} else {
				ind1 = i-1;
				ind2 = i;
			}
			y1 = p[ind1].y;
			y2 = p[ind2].y;
			if (y1 < y2) {
				x1 = p[ind1].x;
				x2 = p[ind2].x;
			} else if (y1 > y2) {
				y2 = p[ind1].y;
				y1 = p[ind2].y;
				x2 = p[ind1].x;
				x1 = p[ind2].x;
			} else {
				continue;
			}
			if ((y >= y1) && (y < y2)) {
				im->polyInts[ints++] = (y-y1) * (x2-x1) / (y2-y1) + x1;
			} else if ((y == maxy) && (y > y1) && (y <= y2)) {
				im->polyInts[ints++] = (y-y1) * (x2-x1) / (y2-y1) + x1;
			}
		}
		qsort(im->polyInts, ints, sizeof(int), gdCompareInt);

		for (i=0; (i < (ints)); i+=2) {
			gdImageLne(im, im->polyInts[i], y,
				im->polyInts[i+1], y, c);
		}
	}
}

/* My re-implemented version of gdImageLine.  The version
   contained in the gd package is better, no doubt about it.
   But in the gd package, the boundaries of polygons are
   determined using a different algorithm than the 
   way lines are drawn.  Thus, if one plots a polygon and then
   plots the edge of the polygon using lines, they don't 
   match ... there is bleeding over from the polygon into 
   areas outside the lines.  This is a problem for grads, where
   the shaded contour routine uses the same algorithm as the 
   line contour routine, so that line contours can be overlaid
   precisely at the boundaries between colors on a shaded plot.
   But then when rendered thru the gd package, they don't line
   up again.

   So, this version of gdImageLine uses the same algorithm as
   gdImageFilledPolygon to determine edges.  Would have been
   better to fix up gxImageFilledPolygon, but that looked to
   be a lot more work... B.Doty 05/31/01 */

void gdImageLne(gdImagePtr im, int x1, int y1, int x2, int y2, int color) {
int x,y,xold,xx;

  /* Fast Path for horizontal or vertical lines */

  if (x1 == x2) { 
    if (y1<y2) {
      for (y=y1; y<=y2; y++) {
         gdImageSetPixel(im, x1, y, color);
      }
    } else {  
      for (y=y2; y<=y1; y++) {
         gdImageSetPixel(im, x1, y, color);
      }
    }
  }

  else if (y1 == y2) {
    if (x1<x2) {
      for (x=x1; x<=x2; x++) {
         gdImageSetPixel(im, x, y1, color);
      }
    } else {  
      for (x=x2; x<=x1; x++) {
         gdImageSetPixel(im, x, y1, color);
      }
    }
    return;
  }

  /* Angled line; this uses lots of integer divides, which
     the *real* gdImageLine avoids.  */

  else {
     
    if (y1<y2) {
      xold = x1;
      for (y=y1; y<=y2; y++) {
         x = (y-y1) * (x2-x1) / (y2-y1) + x1;
         gdImageSetPixel(im, x, y, color);
         if (x-xold>1) {
           for (xx=xold+1; xx<x; xx++) {
              gdImageSetPixel(im, xx, y, color);
           }
         }
         if (xold-x>1) {
           for (xx=x+1; xx<xold; xx++) {
              gdImageSetPixel(im, xx, y, color);
           }
         }
         xold = x;
      }
    } else {  
      xold = x2;
      for (y=y2; y<=y1; y++) {
         x = (y-y2) * (x1-x2) / (y1-y2) + x2;
         gdImageSetPixel(im, x, y, color);
         if (x-xold>1) {
           for (xx=xold+1; xx<x; xx++) {
              gdImageSetPixel(im, xx, y, color);
           }
         }
         if (xold-x>1) {
           for (xx=x+1; xx<xold; xx++) {
              gdImageSetPixel(im, xx, y, color);
           }
         }
         xold = x;
      }
    }
  }
}
