/* -*-Mode: C;-*-
 * Module:      LATS default parameter table
 *
 * Copyright:	1996, Regents of the University of California
 *		This software may not be distributed to others without
 *		permission of the author.
 *
 * Author:      Bob Drach, Lawrence Livermore National Laboratory
 *              drach@llnl.gov
 *
 * Generated:   97-10-7 22:10:40 (drach) from amip2.parms by genlatsparm.pl
 *
 * Version:     $Id: latsparm.h,v 1.1.1.1 2002/06/27 19:44:18 cvsadmin Exp $
 */
#ifndef _LATSPARM_H
#define _LATSPARM_H
#include "latsint.h"
static latsParm latsDefaultParms[] = {
{"cl","Cloud amount","%",150,0,-999,"",0,0,LATS_FLOAT},
{"cli","Cloud ice","kg/kg",226,-999,-999,"",0,0,LATS_FLOAT},
{"clivi","Vertically integrated cloud ice","kg/m^2",151,-999,-999,"atm",1,0,LATS_FLOAT},
{"clt","Total cloud amount","%",71,0,-999,"cltlay",1,0,LATS_FLOAT},
{"clw","Cloud liquid water","kg/kg",225,-999,-999,"",0,0,LATS_FLOAT},
{"clwvi","Vertically integrated cloud water (liquid and solid phase)","kg/m^2",154,-999,-999,"atm",1,0,LATS_FLOAT},
{"enek","Eddy kinetic energy","m^2/s^2",190,-999,12,"",0,0,LATS_FLOAT},
{"evspsbl","Surface evaporation plus sublimation rate","kg/(m^2*s)",141,-999,-999,"sfc",1,0,LATS_FLOAT},
{"hfls","Heat flux latent surface","W/m^2",121,0,-999,"sfc",1,0,LATS_FLOAT},
{"hfss","Heat flux sensible surface","W/m^2",122,0,-999,"sfc",1,0,LATS_FLOAT},
{"hur","Relative humidity","%",52,0,-999,"",0,0,LATS_FLOAT},
{"hus","Specific humidity","kg/kg",51,4,-999,"",0,0,LATS_FLOAT},
{"huss","Surface specific humidity (2m)","kg/kg",51,4,-999,"sfc2m",1,0,LATS_FLOAT},
{"mptta","Mean product of temperature and temperature","K^2",238,-999,16,"",0,0,LATS_FLOAT},
{"mpuua","Mean product of eastward wind and eastward wind","m^2/s^2",236,-999,16,"",0,0,LATS_FLOAT},
{"mpuva","Mean product of eastward and northward wind","m^2/s^2",230,-999,16,"",0,0,LATS_FLOAT},
{"mpvhusa","Mean product of northward wind and specific humidity","m/s",231,-999,16,"",0,0,LATS_FLOAT},
{"mpvta","Mean product of northward wind and temperature","m*K/s",232,-999,16,"",0,0,LATS_FLOAT},
{"mpvva","Mean product of northward wind and northward wind","m^2/s^2",237,-999,16,"",0,0,LATS_FLOAT},
{"mpvzga","Mean product of northward wind and geopotential height","m^2/s",234,-999,16,"",0,0,LATS_FLOAT},
{"mpwapta","Mean product of vertical motion and temperature","Pa/(K*s)",235,-999,16,"",0,0,LATS_FLOAT},
{"mpwhusa","Mean product of vertical motion and specific humidity","Pa/s",233,-999,16,"",0,0,LATS_FLOAT},
{"mrfso","Total soil frozen water content","kg/m^2",137,-999,-999,"landt",1,0,LATS_FLOAT},
{"mrro","Total runoff rate (including drainage)","kg/(m^2*s)",131,-999,-999,"lands",1,0,LATS_FLOAT},
{"mrros","Surface runoff rate","kg/(m^2*s)",132,-999,-999,"lands",1,0,LATS_FLOAT},
{"mrso","Total soil mositure","kg/m^2",86,0,-999,"landt",1,0,LATS_FLOAT},
{"mrsofc","Total soil moisture at field capacity","kg/m^2",134,-999,-999,"landt",1,0,LATS_FLOAT},
{"mrsofcs","Surface soil moisture (upper 0.1m) at field capacity","kg/m^2",133,0,-999,"lands",1,0,LATS_FLOAT},
{"mrsos","Surface soil moisture (upper 0.1m)","kg/m^2",135,1,-999,"lands",1,0,LATS_FLOAT},
{"mrsotb","Soil moisture % field capacity","%",136,0,-999,"landt",1,0,LATS_FLOAT},
{"orog","Model topography","m",8,0,-999,"sfc",1,0,LATS_FLOAT},
{"pr","Total precipitation rate","kg/(m^2*s)",59,6,-999,"sfc",1,0,LATS_FLOAT},
{"prc","Convective precipitation rate","kg/(m^2*s)",144,6,-999,"sfc",1,0,LATS_FLOAT},
{"prsn","Snowfall rate (water equivalent)","kg/(m^2/s)",64,6,-999,"sfc",1,0,LATS_FLOAT},
{"prw","Precipitable water","kg/m^2",54,1,-999,"sfc",1,0,LATS_FLOAT},
{"ps","Surface pressure","Pa",1,0,-999,"sfc",1,0,LATS_FLOAT},
{"psbg","Pressure surface below ground percentage","%",128,0,-999,"",0,0,LATS_FLOAT},
{"psl","Mean sea-level pressure","Pa",2,0,-999,"msl",1,0,LATS_FLOAT},
{"rlds","LW radiation downward surface","W/m^2",205,1,-999,"sfc",1,0,LATS_FLOAT},
{"rldscs","LW radiation downward surface clear sky","W/m^2",163,1,-999,"sfc",1,0,LATS_FLOAT},
{"rlns","LW radiation net surface","W/m^2",112,1,-999,"sfc",1,0,LATS_FLOAT},
{"rlus","LW radiation upward surface","W/m^2",188,1,-999,"sfc",1,0,LATS_FLOAT},
{"rluscs","LW radiation upward surface clear sky","W/m^2",162,1,-999,"sfc",1,0,LATS_FLOAT},
{"rlut","LW radiation TOA (OLR)","W/m^2",114,1,-999,"toa",1,0,LATS_FLOAT},
{"rlutcs","LW radiation TOA clear sky","W/m^2",162,1,-999,"toa",1,0,LATS_FLOAT},
{"rsds","SW radiation incident at the surface","W/m^2",204,1,-999,"sfc",1,0,LATS_FLOAT},
{"rsdscs","SW radiation downward clear sky surface","W/m^2",184,1,-999,"sfc",1,0,LATS_FLOAT},
{"rsdt","SW radiation downward TOA","W/m^2",204,1,-999,"toa",1,0,LATS_FLOAT},
{"rsns","SW radiation net surface","W/m^2",111,1,-999,"sfc",1,0,LATS_FLOAT},
{"rsnt","SW radiation net TOA","W/m^2",113,1,-999,"toa",1,0,LATS_FLOAT},
{"rsus","SW radiaton upward (reflected) surface","W/m^2",181,1,-999,"sfc",1,0,LATS_FLOAT},
{"rsuscs","SW radiation upward surface clear sky","W/m^2",185,1,-999,"sfc",1,0,LATS_FLOAT},
{"rsut","SW radiation upward TOA","W/m^2",183,1,-999,"toa",1,0,LATS_FLOAT},
{"rsutcs","SW radiation upward TOA clear sky","W/m^2",186,1,-999,"toa",1,0,LATS_FLOAT},
{"rtmt","Net Radiation at Model Top","W/m^2",180,1,-999,"modtop",1,0,LATS_FLOAT},
{"sftgif","Sfc type % glacier","%",253,-999,1,"sfc",1,0,LATS_FLOAT},
{"sftlf","Sfc type % land","%",252,0,-999,"sfc",1,0,LATS_FLOAT},
{"sic","Sea-ice concentration","%",227,0,-999,"sfc",1,0,LATS_FLOAT},
{"sicbcs","AMIP II BCS Psuedo Sea-ice concentration","%",250,0,-999,"sfc",1,0,LATS_FLOAT},
{"snc","Snow cover (percent area)","%",228,0,-999,"sfc",1,0,LATS_FLOAT},
{"snd","Snow depth","m",66,2,-999,"sfc",1,0,LATS_FLOAT},
{"snm","Snow melt","kg/m^2",99,1,-999,"sfc",1,0,LATS_FLOAT},
{"snw","Snow depth (water equivalent)","kg/m^2",65,0,-999,"sfc",1,0,LATS_FLOAT},
{"ta","Air Temperature","K",11,1,-999,"",0,0,LATS_FLOAT},
{"tas","Surface (2m) air temperature","K",11,1,-999,"sfc2m",1,0,LATS_FLOAT},
{"tasmax","Daily maximum surface (2m) temperature","K",15,1,-999,"sfc2m",1,0,LATS_FLOAT},
{"tasmin","Daily minimum surface (2m) temperature","K",16,1,-999,"sfc2m",1,0,LATS_FLOAT},
{"tauu","Eastward surface wind stress (positive for eastward wind)","N/m^2",124,3,-999,"sfc",1,0,LATS_FLOAT},
{"tauugwd","GWD induced eastward surface wind stress (+ for east wind)","N/m^2",222,3,-999,"sfc",1,0,LATS_FLOAT},
{"tauv","Northward surface wind stress (positive for northward wind)","N/m^2",125,3,-999,"sfc",1,0,LATS_FLOAT},
{"tauvgwd","GWD induced northward surface wind stress (+ for north wind)","N/m^2",223,3,-999,"sfc",1,0,LATS_FLOAT},
{"tnmmc","Momentum tendency due to convection","m/s^2",219,7,-999,"",0,0,LATS_FLOAT},
{"tnmmgwd","Momentum tendency due to gravity wave drag","m/s^2",218,7,-999,"",0,0,LATS_FLOAT},
{"tnmmgwdu","Eastward momentum tendency due to gravity wave drag","m/s^2",220,7,-999,"",0,0,LATS_FLOAT},
{"tnmmgwdv","Northward momentum tendency due to gravity wave drag","m/s^2",221,7,-999,"",0,0,LATS_FLOAT},
{"tnmrc","Moisture tendency due to convective processes","(kg/kg)/s",217,7,-999,"",0,0,LATS_FLOAT},
{"tnmrd","Moisture tendency due to diabatic processes","(Kg/Kg)/s",216,-999,12,"",0,0,LATS_FLOAT},
{"tnt","Total diabatic temperature tendency","K/s",210,7,-999,"",0,0,LATS_FLOAT},
{"tntdc","Temperature tendency due to dry convective processes","K/s",214,7,-999,"",0,0,LATS_FLOAT},
{"tntlsp","Temperature tendency due to large scale precipation","K/s",215,7,-999,"",0,0,LATS_FLOAT},
{"tntlw","Temperature tendency due to LW radiation","K/s",212,7,-999,"",0,0,LATS_FLOAT},
{"tntmc","Temperature tendency due to moist convective processes","K/s",213,7,-999,"",0,0,LATS_FLOAT},
{"tntsw","Temperature tendency due to SW radiation","K/s",211,7,-999,"",0,0,LATS_FLOAT},
{"tos","Sea Surface Temperature","K",80,2,-999,"sfc",1,0,LATS_FLOAT},
{"tosbcs","AMIP II BCS Psuedo Sea Surface Temperature","K",251,2,-999,"sfc",1,0,LATS_FLOAT},
{"tro3","Ozone Concentration","ppmv",129,-999,12,"",0,0,LATS_FLOAT},
{"ts","Ground Surface Temperature","K",11,1,12,"sfc",1,0,LATS_FLOAT},
{"ua","Eastward wind","m/s",33,1,-999,"",0,0,LATS_FLOAT},
{"uas","Surface (10m) eastward wind","m/s",33,1,-999,"sfc10m",1,0,LATS_FLOAT},
{"va","Northward wind","m/s",34,1,-999,"",0,0,LATS_FLOAT},
{"vas","Surface (10m) northward wind","m/s",34,1,-999,"sfc10m",1,0,LATS_FLOAT},
{"vorpot","Potential vorticity (350, 380, 405K)","1/(Pa*s)",206,-999,-999,"",0,0,LATS_FLOAT},
{"wap","Vertical motion (omega)","Pa/s",39,3,-999,"",0,0,LATS_FLOAT},
{"zbla","Planetary boundary layer height","m",170,-999,12,"pbltop",1,0,LATS_FLOAT},
{"zg","Geopotential height","m",7,0,-999,"",0,0,LATS_FLOAT}
};
#define LATS_DEFAULT_NPARMS (sizeof latsDefaultParms / sizeof(latsParm))
static latsVertType latsDefaultVerts[] = {
{"0degiso","0 deg isotherm","hPa",LATS_UP,LATS_SINGLE_LEVEL,4,0,0,0},
{"atm","Atmosphere (entire)","",LATS_UP,LATS_SINGLE_LEVEL,200,0,0,0 },
{"ocn","Ocean (entire depth)","",LATS_UP,LATS_SINGLE_LEVEL,201,0,0,0 },
{"ocnbot","Ocean Bottom","",LATS_UP,LATS_SINGLE_LEVEL,202,0,0,0 },
{"clhbot","High Cloud Bottom Level","hPa",LATS_UP,LATS_SINGLE_LEVEL,232,0,0,0},
{"clhlay","High Cloud Top Layer","",LATS_UP,LATS_SINGLE_LEVEL,234,0,0,0},
{"clhtop","High Cloud Top Level","hPa",LATS_UP,LATS_SINGLE_LEVEL,233,0,0,0},
{"cllbot","Low Cloud Bottom Level","hPa",LATS_UP,LATS_SINGLE_LEVEL,212,0,0,0},
{"clllay","Low Cloud Top Layer","",LATS_UP,LATS_SINGLE_LEVEL,214,0,0,0},
{"clltop","Low Cloud Top Level","hPa",LATS_UP,LATS_SINGLE_LEVEL,213,0,0,0},
{"clmbot","Mid Cloud Bottom Level","hPa",LATS_UP,LATS_SINGLE_LEVEL,222,0,0,0},
{"clmlay","Mid Cloud Top Layer","",LATS_UP,LATS_SINGLE_LEVEL,224,0,0,0},
{"clmtop","Mid Cloud Top Level","hPa",LATS_UP,LATS_SINGLE_LEVEL,223,0,0,0},
{"cltbot","Cloud base level","hPa",LATS_UP,LATS_SINGLE_LEVEL,2,0,0,0},
{"cltlay","Total Cloud layer","",LATS_UP,LATS_SINGLE_LEVEL,3,0,0,0},
{"cltmax","Highest Cloud height","m",LATS_UP,LATS_SINGLE_LEVEL,105,0,0,0},
{"landd","Below ground, 10 to 200 cm","",LATS_UP,LATS_SINGLE_LEVEL,112,10,200,0},
{"lands","Below ground, 0 to 10 cm","",LATS_UP,LATS_SINGLE_LEVEL,112,0,10,0},
{"landt","Below ground, 0  to 200 cm","",LATS_UP,LATS_SINGLE_LEVEL,112,0,200,0},
{"lcl","Adiabatic cond level","hPa",LATS_UP,LATS_SINGLE_LEVEL,5,0,0,0},
{"maxwnd","Maximum wind speed level","hPa",LATS_UP,LATS_SINGLE_LEVEL,6,0,0,0},
{"msl","Mean Sea Level","",LATS_UP,LATS_SINGLE_LEVEL,102,0,0,0},
{"ocnbot","Ocean bottom","",LATS_UP,LATS_SINGLE_LEVEL,9,0,0,0},
{"plev","Pressure level","hPa",LATS_DOWN,LATS_MULTI_LEVEL,100,0,0,0},
{"pbltop","Top of PBL","",LATS_UP,LATS_SINGLE_LEVEL,21,0,0,0},
{"sfc","Earth surface","",LATS_UP,LATS_SINGLE_LEVEL,1,0,0,0},
{"sfclo","Sfc Layer Ocean","",LATS_UP,LATS_SINGLE_LEVEL,112,0,300,0},
{"sfc10m","10 meters above earth surface","m",LATS_UP,LATS_SINGLE_LEVEL,105,0,0,10},
{"sfc2m","2 meters above earth surface","m",LATS_UP,LATS_SINGLE_LEVEL,105,0,0,2},
{"toa","Top of atmosphere","",LATS_UP,LATS_SINGLE_LEVEL,8,0,0,0},
{"modtop","Top of Model","",LATS_UP,LATS_SINGLE_LEVEL,20,0,0,0},
{"toasat","TOA satellite","",LATS_UP,LATS_SINGLE_LEVEL,22,0,0,0},
{"troplev","Tropopause level","hPa",LATS_UP,LATS_SINGLE_LEVEL,7,0,0,0},
{"theta","Isentropic Level","K",LATS_UP,LATS_MULTI_LEVEL,113,0,0,0},
{"sigma","Sigma level","",LATS_DOWN,LATS_MULTI_LEVEL,107,0,0,0},
{"hybrid","Hybrid Model level number","",LATS_UP,LATS_MULTI_LEVEL,109,0,0,0},
{"zocean","Depth below sea level","m",LATS_DOWN,LATS_MULTI_LEVEL,160,0,0,0}
};
#define LATS_DEFAULT_NVERTS (sizeof latsDefaultVerts / sizeof(latsVertType))
static latsCenter latsDefaultCenters[] = {
{"bmrc",1,100,2},
{"ccc",2,100,2},
{"cnrm",3,100,2},
{"cola",4,100,2},
{"csiro",5,100,2},
{"csu",6,100,2},
{"dnm",7,100,2},
{"ecmwf",8,100,2},
{"gfdl",9,100,2},
{"derf",10,100,2},
{"giss",11,100,2},
{"gla",12,100,2},
{"gsfc",13,100,2},
{"iap",14,100,2},
{"jma",15,100,2},
{"lmd",16,100,2},
{"mgo",17,100,2},
{"mpi",18,100,2},
{"mri",19,100,2},
{"ncar",20,100,2},
{"ncep",21,100,2},
{"nrl",22,100,2},
{"rpn",23,100,2},
{"sunya",24,100,2},
{"sunya/ncar",25,100,2},
{"ucla",26,100,2},
{"ugamp",27,100,2},
{"uiuc",28,100,2},
{"ukmo",29,100,2},
{"yonu",30,100,2},
{"ccsr",31,100,2},
{"llnl",32,100,2},
{"ntu",33,100,2},
{"pcmdi",100,100,2}
};
#define LATS_DEFAULT_NCENTERS (sizeof latsDefaultCenters / sizeof(latsCenter))
static latsParmQC latsDefaultQCs[] = {
{"_default_"}
};
#define LATS_DEFAULT_NQCS (sizeof latsDefaultQCs / sizeof(latsParmQC))
#endif
