#!/bin/tcsh 
#
# w32_dist.csh - last update: 18 oct 2001
#
# Script for creating a Win32 distribution for later
# "packing" with EasyInstall
#
# Notice that it is important to preserve the following directory
# structure:
#
# $(TARGETDIR)/win32       binaries, e.g., gradsc.exe
# $(TARGETDIR)/dat         map database, fonts, etc.
# $(TARGETDIR)/lib         gs and gui scripts
# $(TARGETDIR)/doc         documentation
#
# where $(TARGETDIR) is wherever the user chooses for installation.
# Preserving this structure is important for the frontend mechanism.
#
# NOTE# The final installation will have the directories win32a/ and 
#       win32b/ consolidated into a single win32/ directory with all
#       the binaries. If you are not intending to use InstallShield
#       just set BINa=%TARGET%\win32 and set BINb=%BINa%
#
# Send questions to Arlindo da Silva (dasilva@alum.mit.edu)
# 

# Parse cmd line
# --------------
if ( $#argv < 1 ) then
    echo "Usage:  w32_dist.csh  win32|win32e"
    exit 1
endif

if ( "$1" == "win32" || "$1" == "win32e" ) then
     set mach = $1
else
     echo $0": $1 is not a valid architecture; enter either win32 or win32e"
     exit 1
endif

  
# Directories referenced by this BAT file
# ---------------------------------------
  set  TARGET="../pc-dist"
  set    BIN=$TARGET/$mach
  set   FUTIL=../win32/bin
  set    XDIR=/usr/X11R6

# Create directories if they are not there
# ----------------------------------------
  /bin/mkdir -p $TARGET $BIN

# Start cleaning up
# -----------------
  echo "Cleaning up.."
  foreach ext ( exe dll pl bak hlp )
    /bin/rm -f $BIN/*.$ext
  end

# Start copying necessary DLLs
# ----------------------------
  echo "Copying DLLs.."
  foreach dll ( cygjbig1.dll cygjpeg6b.dll cygncurses6.dll cygreadline5.dll \
                cygtiff3.dll cygwin1.dll cygz.dll libW11.dll )
     /bin/cp /bin/$dll $BIN
  end
  if ( "$mach" == "win32" ) then
     foreach dll ( libICE.dll libSM.dll libX11.dll libXext.dll libXpm.dll \
                libdps.dll libdpstk.dll )
        /bin/cp $XDIR/bin/$dll $BIN
     end
  endif

# List of binaries
# 
  if ( "$mach" == "win32" ) then  
        set bins = ( GradsC Gxtran GradsNC GradsHDF GradsDODS GradsGUI )
  else
        set bins = ( GradsC Gxtran GradsNC GradsHDF GradsDODS )
  endif 

# Now copy GrADS binaries; rename binaries needing frontend as *.dll
# NOTE: These are not really DLL, this is just a trick.
# ---------------------------------------------------------------
  echo "Copying GrADS binaries..."
  /bin/cp *.exe $BIN
  foreach bin ( $bins )
     /bin/mv $BIN/$bin.exe $BIN/$bin.dll
  end
 
# GNU sh and basic GNU file utils
# -------------------------------
  foreach exe ( tcsh sh ls cp rm mv dir pwd cat date mkdir )
    /bin/cp /bin/$exe.exe $BIN
  end

# Now the grads file utils.
# ------------------------
  echo "Copying file utils..."
  foreach ext ( exe hlp )
      /bin/cp $FUTIL/*.$ext $BIN
  end
  if ( "$mach" == "win32" ) then  # only win32 takes Magick
      /bin/cp $FUTIL/Magick/* $BIN
  endif

# Next, setup the front ends
# --------------------------
  echo "Finishing up ..."
  foreach bin ( $bins )
     /bin/cp $BIN/win32run.exe $BIN/$bin.exe
  end
  /bin/mv $BIN/win32run.exe $BIN/Grads.exe

# All done
# --------
  echo "Win32 GrADS distribution tree completed."  
  exit 0

