#!/bin/sh 

rm -f reanalconv.out soilconv.out

if [ $# -ne 3 ] 
then

echo " "
echo "need three arguments"
echo " "
echo "starting date yymmddhh"
echo "ending date   yymmddhh"
echo "interval (e.g. 06)    "
echo " "
echo " "

exit

fi

startd=$1
endd=$2
interval=$3

yy=`echo $startd | cut -c1-2`
mm=`echo $startd | cut -c3-4`
dd=`echo $startd | cut -c5-6`
hh=`echo $startd | cut -c7-8`

ROOT=`pwd`/..
cd ../../data/grib
rm -f reanalconv.out soilconv.out
pathname=`pwd`

while [ $yy$mm$dd$hh -le $endd ]
do

echo "start while, " $yy $mm $dd $hh

## do stuff, then increment time

start=`pwd`
hr=T${1}Z
int=${3}
endtime=${2}
model=pgb.f00
tval=0

cd $start 

rm -f avnconv.out

if [ $tval -le 9 ] 
then
tval=0${tval}
fi

LOGDIR=$ROOT'/log'
filename=${model}$yy$mm$dd$hh
GRIBFILE=${pathname}/${filename}
OUTDIR=$ROOT'/../data/prep'

echo " "
echo " ******************************************************"
echo " *** GRIB grid processor ***"
echo " Begin processing for "$filename

# Degrib data.

if [ -e $GRIBFILE ] 
then

echo " Start degrib process..."

else

echo " "
echo " ************************************************************"
echo " "
echo " "$GRIBFILE" grib file not found."
exit 0

fi

# Convert degribbed data to unformatted format for local area model use.

echo " "
echo " Start degrib to formatted data conversion process..."
echo " "
 
$ROOT/exe/dgeta2model_gbl.exe << endin
$GRIBFILE
$OUTDIR
endin
 
# Cleanup.

if [ $tval -le $endtime ] 
then
echo $tval $int
tval=`expr $tval + $int`
fi

# end

hh=`expr $hh + $interval`

echo "new hh is" $hh

if [ $hh -ge 24 ] 
then
hh=`expr $hh - 24`

echo "find a new day " $mm $dd

if [ $mm -eq 1 -o $mm -eq 01 ] 
then
mxd=31
fi

if [ $mm -eq 2 -o $mm -eq 02 ] 
then
   leap=`expr $yy % 4`
    if [ $leap -eq 0 ] 
    then
    mxd=29
    fi
    if [ $leap -ne 0 ] 
    then
    mxd=28
    fi
fi


if [ $mm -eq 3 -o $mm -eq 03 ] ; then
mxd=31
fi

if [ $mm -eq 4 -o $mm -eq 04 ] ; then
mxd=30
fi

if [ $mm -eq 5 -o $mm -eq 05 ] ; then
mxd=31
fi

if [ $mm -eq 6 -o $mm -eq 06 ] ; then
mxd=30
fi

if [ $mm -eq 7 -o $mm -eq 07 ] ; then
mxd=31
fi

if [ $mm -eq 8 -o $mm -eq 08 ] ; then
mxd=31
fi

if [ $mm -eq 9 -o $mm -eq 09 ] ; then
mxd=30
fi

if [ $mm -eq 10 ] ; then
mxd=31
fi

if [ $mm -eq 11 ] ; then
mxd=30
fi

if [ $mm -eq 12 ] ; then
mxd=31
fi

echo "max days in month: " $mxd

dd=`expr $dd + 1`

echo "new dd: " $dd

if [ $dd -gt $mxd ] 
then
    mm=`expr $mm + 1`
    if [ $mm -eq 13 ] 
	then
        yy=`expr $yy + 1`
        mm=1
    fi
    dd=1
fi
yy=`expr $yy + 0`
mm=`expr $mm + 0`
dd=`expr $dd + 0`
hh=`expr $hh + 0`

if [ $yy -lt 10 ] ; then
yy=0$yy
fi

if [ $mm -lt 10 ] ; then
mm=0$mm
fi

if [ $dd -lt 10 ] ; then
dd=0$dd
fi

echo "now have yy mm dd: " $yy $mm $dd
fi


hh=`expr $hh + 0`

echo $hh

if [ $hh -lt 10 ] ; then
hh=0${hh}
fi

echo "end while, " $yy$mm$dd$hh $endd

done
exit 0
