c***********************************************************************
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
C  THIS SUBROUTINE INTEGRATES THE AREA UNDER THE CURVE IN THE GAUSSIAN  
C  DISTRIBUTION...THE NUMERICAL APPROXIMATION TO THE INTEGRAL IS TAKEN 
C  FROM ""HANDBOOK OF MATHEMATICAL FUNCTIONS WITH FORMULAS, GRAPHS AND 
C  MATHEMATICAL TABLES"" ED. BY ABRAMOWITZ AND STEGUN, NATL BUREAU OF 
C  STANDARDS AND APPLIED MATHEMATICS SERIES.  JUNE, 1964., MAY, 1968.                         
C                                     JACK KAIN
C                                     7/6/89                            
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
C***********************************************************************  
C*****    GAUSSIAN TYPE MIXING PROFILE....******************************
C***********************************************************************  
      SUBROUTINE PROF5(EQ,EE,UD)
C
      DATA SQRT2P,A1,A2,A3,P,SIGMA,FE/2.506628,0.4361836,-0.1201676
     1,0.9372980,0.33267,0.166666667,0.202765151/                        
C
      X=(EQ-0.5)/SIGMA                                                  
      Y=6.*EQ-3.                                                        
      EY=EXP(Y*Y/(-2))                                                  
      E45=EXP(-4.5)                                                     
      T2=1./(1.+P*ABS(Y))                                               
      T1=0.500498                                                       
      C1=A1*T1+A2*T1*T1+A3*T1*T1*T1                                     
      C2=A1*T2+A2*T2*T2+A3*T2*T2*T2                                     
      IF(Y.GE.0.)THEN                                                   
        EE=SIGMA*(0.5*(SQRT2P-E45*C1-EY*C2)+SIGMA*(E45-EY))-E45*EQ*EQ/2.
        UD=SIGMA*(0.5*(EY*C2-E45*C1)+SIGMA*(E45-EY))-E45*(0.5+EQ*EQ/2.- 
     1     EQ)                                                          
      ELSE                                                              
        EE=SIGMA*(0.5*(EY*C2-E45*C1)+SIGMA*(E45-EY))-E45*EQ*EQ/2.       
        UD=SIGMA*(0.5*(SQRT2P-E45*C1-EY*C2)+SIGMA*(E45-EY))-E45*(0.5+EQ*
     1     EQ/2.-EQ)                                                    
      ENDIF                                                             
C
      EE=EE/FE                                                          
      UD=UD/FE                                                          
C------------------------------------------------------------------------
      RETURN                                                            
      END                                                               
