      SUBROUTINE BOUND(FLD,FMIN,FMAX,IM,JM)
C$$$  SUBPROGRAM DOCUMENTATION BLOCK
C                .      .    .     
C SUBPROGRAM:    BOUND       CLIPS DATA IN PASSED ARRAY
C   PRGRMMR: TREADON         ORG: W/NP2      DATE: 93-01-18
C     
C ABSTRACT:  THIS ROUTINE BOUNDS DATA IN THE PASSED ARRAY 
C   FLD (IMxJM ELEMENTS LONG) AND CLIPS DATA VALUES SUCH 
C   THAT ON EXITING THE ROUTINE 
C                FMIN <= FLD(I,J) <= FMAX
C   FOR ALL POINTS.
C
C   THIS ROUTINE "BOUNDS" THE FULL ARRAY BY MPI TASK 0
C
C     
C PROGRAM HISTORY LOG:
C   93-01-18  RUSS TREADON
C   93-05-07  RUSS TREADON - ADDED DOCBLOC
C   98-05-29  BLACK - CONVERSION FROM 1-D TO 2-D
C   00-01-04  JIM TUCCILLO - MPI VERSION        
C     
C USAGE:    CALL BOUND(FLD,FMIN,FMAX,NPTS)
C   INPUT ARGUMENT LIST:
C     FMIN     - LOWER (INCLUSIVE) BOUND FOR DATA.
C     FMAX     - UPPER (INCLUSIVE) BOUND FOR DATA.
C     IM,JM    - DIMENSION OF DATA ARRAY FLD.
C
C   OUTPUT ARGUMENT LIST: 
C     FLD      - ARRAY WHOSE ELEMENTS ARE BOUNDED BY [FMIN,FMAX].
C     
C   OUTPUT FILES:
C     NONE
C     
C   SUBPROGRAMS CALLED:
C     UTILITIES:
C       NONE
C     LIBRARY:
C       NONE
C
C   ATTRIBUTES:
C     LANGUAGE: FORTRAN 90
C     MACHINE : CRAY C-90
C$$$  
C     
C     
      INCLUDE "CTLBLK.comm"
C     
C     DECLARE VARIABLES.
      REAL FMAX, FMIN, FLD(IM,JM)
C     
C     
C**********************************************************************
C     START BOUND HERE.
C     
C     BOUND ARRAY.
!$omp  parallel do
      IF ( ME .EQ. 0 ) THEN
      DO J=1,JM
      DO I=1,IM
        FLD(I,J) = AMAX1(FMIN,FLD(I,J))
        FLD(I,J) = AMIN1(FLD(I,J),FMAX)
      ENDDO
      ENDDO
      END IF
C     
C     END OF ROUTINE.
C     
      RETURN
      END
