      SUBROUTINE CALDRG(DRAGCO)
C$$$  SUBPROGRAM DOCUMENTATION BLOCK
C                .      .    .     
C SUBPROGRAM:    CALDRG      COMPUTE DRAG COEFFICIENT
C   PRGRMMR: TREADON         ORG: W/NP2      DATE: 93-09-01
C     
C ABSTRACT:  THIS ROUTINE COMPUTES A SURFACE LAYER DRAG
C   COEFFICIENT USING EQUATION (7.4.1A) IN "AN INTRODUCTION
C   TO BOUNDARY LAYER METEOROLOGY" BY STULL (1988, KLUWER
C   ACADEMIC PUBLISHERS).
C   .     
C     
C PROGRAM HISTORY LOG:
C   93-09-01  RUSS TREADON
C   98-06-15  T BLACK - CONVERSION FROM 1-D TO 2-D
C   00-01-04  JIM TUCCILLO - MPI VERSION           
C     
C USAGE:    CALL CALDRG(DRAGCO)
C   INPUT ARGUMENT LIST:
C     NONE     
C
C   OUTPUT ARGUMENT LIST: 
C     DRAGCO   - SURFACE LAYER DRAG COEFFICIENT
C     
C   OUTPUT FILES:
C     NONE
C     
C   SUBPROGRAMS CALLED:
C     UTILITIES:
C       NONE
C     LIBRARY:
C       COMMON   - LOOPS
C                  VRBLS
C                  SRFDSP
C                  PVRBLS
C     
C   ATTRIBUTES:
C     LANGUAGE: FORTRAN 90
C     MACHINE : CRAY C-90
C$$$  
C     
C
C     INCLUDE/SET PARAMETERS.
C     
      INCLUDE "parmeta"
      INCLUDE "params"
C     
C     DECLARE VARIABLES.
      REAL DRAGCO(IM,JM)
C     
C     INCLUDE COMMON BLOCKS.
C     
      INCLUDE "LOOPS.comm"
      INCLUDE "VRBLS.comm"
      INCLUDE "SRFDSP.comm"
      INCLUDE "PVRBLS.comm"
      INCLUDE "INDX.comm"
      INCLUDE "CTLBLK.comm"
C     
C     
C********************************************************************
C     START CALDRG HERE.
C     
C     INITIALIZE DRAG COEFFICIENT ARRAY TO ZERO.
C     
      DO J=JSTA,JEND
      DO I=1,IM
        DRAGCO(I,J) = D00
      ENDDO
      ENDDO
C     
C     COMPUTE A SURFACE LAYER DRAG COEFFICIENT.
C
      CALL EXCH(UZ0)
      CALL EXCH(VZ0)
C
C     ASSUMET THAT U AND V HAVE HALOS
C   
      DO 30 J=JSTA_M,JEND_M
      DO 30 I=2,IM-1
C     
C        COMPUTE A MEAN MASS POINT WIND IN THE 
C        FIRST ATMOSPHERIC ETA LAYER.
C
      LMHK=LMH(I,J)
      IE=I+IHE(J)
      IW=I+IHW(J)
      SUMU=U(IE,J,LMV(IE,J))+U(IW,J,LMV(IW,J))+U(I,J-1,LMV(I,J-1)) 
     1    +U(I,J+1,LMV(I,J+1))
      SUMV=V(IE,J,LMV(IE,J))+V(IW,J,LMV(IW,J))+V(I,J-1,LMV(I,J-1)) 
     1    +V(I,J+1,LMV(I,J+1))
      ULMH=D25*SUMU
      VLMH=D25*SUMV
C     
C        COMPUTE A MEAN MASS POINT WIND AT HEIGHT Z0.
C
      UZ0H=D25*(UZ0(IE,J)+UZ0(IW,J)+UZ0(I,J-1)+UZ0(I,J+1))
      VZ0H=D25*(VZ0(IE,J)+VZ0(IW,J)+VZ0(I,J-1)+VZ0(I,J+1))
C     
C        COMPUTE A MEAN MASS POINT WIND SPEED BETWEEN THE
C        FIRST ATMOSPHERIC ETA LAYER AND Z0.
C
      UBAR=D50*(ULMH+UZ0H)
      VBAR=D50*(VLMH+VZ0H)
      WSPDSQ=UBAR*UBAR+VBAR*VBAR
C     
C        COMPUTE A DRAG COEFFICIENT.
C
      USTRSQ=USTAR(I,J)*USTAR(I,J)
      DRAGCO(I,J)=USTRSQ/WSPDSQ
C
   30 CONTINUE
C     
C     END OF ROUTINE.
C     
      RETURN
      END
