      SUBROUTINE CALSTRM(Z1D,STRM)
C$$$  SUBPROGRAM DOCUMENTATION BLOCK
C                .      .    .     
C SUBPROGRAM:    CALSTRM     COMPUTES GEO STREAMFUNCTION
C   PRGRMMR: TREADON         ORG: W/NP2      DATE: 92-12-22
C     
C ABSTRACT:  
C     THIS ROUTINE COMPUTES THE GEOSTROPHIC STREAMFUNCTION,
C     PSI, FROM THE PASSED GEOPOTENTIAL HEIGHT FIELD, Z.  
C     THE FORMULA USED IS PSI = G*Z/F0, WHERE G IS THE
C     GRAVITATIONAL ACCELERATION CONSTANT AND F0 IS A 
C     CONSTANT CORIOLIS PARAMETER.  F0 IS SET TO BE THE
C     VALUE OF THE CORIOLIS PARAMETER ALONG THE CENTRAL
C     (GEODETIC) LATITUDE (IE, TPH0D) OF THE MODEL GRID.
C   .     
C     
C PROGRAM HISTORY LOG:
C   92-12-22  RUSS TREADON
C   98-06-08  T BLACK - CONVERSION FROM 1-D TO 2-D
C   00-01-05  JIM TUCCILLO - MPI VERSION
C     
C USAGE:    CALL CALSTRM(Z1D,STRM)
C   INPUT ARGUMENT LIST:
C     Z1D      - GEOPOTENTIAL HEIGHT (M)
C
C   OUTPUT ARGUMENT LIST: 
C     STRM     - GEOSTROPHIC STREAMFUNCTION
C     
C   OUTPUT FILES:
C     NONE
C     
C   SUBPROGRAMS CALLED:
C     UTILITIES:
C       NONE
C     LIBRARY:
C       COMMON   - MAPOT
C     
C   ATTRIBUTES:
C     LANGUAGE: FORTRAN
C     MACHINE : CRAY C-90
C$$$  
C     
C
C     
C     
C     INCLUDE ETA GRID DIMENSIONS.  SET/DERIVE OTHER PARAMETERS.
C     
      INCLUDE "parmeta"
      INCLUDE "params"
      PARAMETER (OMEGA=7.292E-5,TWOMG=2*OMEGA)
C
C     DECLARE VARIABLES.
C     
      LOGICAL FIRST,OLDRD,RESTRT,RUN,SIGMA,STRD
      REAL Z1D(IM,JM),STRM(IM,JM)
C     
C     DECLARE COMMONS.
      INCLUDE "MAPOT.comm"
      INCLUDE "CTLBLK.comm"
C     
C***************************************************************************
C     START CALSTRM HERE.
C     
C     COMPUTE CORIOLIS PARAMETER ALONG CENTRAL GEODETIC 
C     OF STAGGERED E-GRID LATITUDE.
      F0   = TWOMG*SIN(TPH0D*DTR)
      GOF0 = G/F0
C     
C     COMPUTE GEOSTROPHIC STREAMFUNCTION.
!$omp  parallel do
      DO J=JSTA,JEND
      DO I=1,IM
        STRM(I,J)=GOF0*Z1D(I,J)
      ENDDO
      ENDDO
C     
C     END OF ROUTINE.
      RETURN
      END
