      SUBROUTINE EFILL(EGRID,IM,JM)
C$$$  SUBPROGRAM DOCUMENTATION BLOCK
C                .      .    .     
C SUBPROGRAM:    EFILL       FILLS MISSING VALUES ON E-GRID
C   PRGRMMR: TREADON         ORG: W/NP2 
C     
C ABSTRACT:  
C     THIS ROUTINE REPLACES ARRAY ELEMENTS ON A E-GRID MARKED
C     BY A MISSING DATA FLAG WITH THE FIELD MEAN.  THE FIELD
C     MEAN IS COMPUTED FROM ALL NON-MISSING ARRAY VALUES.
C     THE MISSING DATA FLAG, SPVAL,  IS SET IN INCLUDE FILE
C     (AND COMMON BLOCK) OPTIONS.
C   .     
C     
C PROGRAM HISTORY LOG:
C   93-02-03  RUSS TREADON
C   98-06-01  BLACK - CONVERSION FROM 1-D TO 2-D
C     
C USAGE:    CALL EFILL(EGRID,IM,JM)
C   INPUT ARGUMENT LIST:
C     EGRID    - DATA ON STAGGERED E-GRID
C     IM,JM    - DIMENSIONS OF E-GRID
C
C   OUTPUT ARGUMENT LIST: 
C     EGRID    - SAME A INPUT EXCEPT MISSING VALUES
C                ARE REPLACED BY THE FIELD MEAN
C     
C   OUTPUT FILES:
C     STDOUT  - RUN TIME STANDARD OUT.
C     
C   SUBPROGRAMS CALLED:
C     UTILITIES:
C       NONE
C     LIBRARY:
C       COMMON   - OPTIONS
C                  IOUNIT
C     
C   ATTRIBUTES:
C     LANGUAGE: FORTRAN
C     MACHINE : CRAY C-90
C$$$  
C     
C     SET PARAMETER
      PARAMETER (SMALL=1.E-12)
C
C     DECLARE VARIABLES
      REAL EGRID(IM,JM)
      DOUBLE PRECISION SUM
C     
C     INCLUDE COMMON BLOCK WITH SPVAL
      INCLUDE "OPTIONS.comm"
      INCLUDE "IOUNIT.comm"
C     
C**********************************************************************
C     START EFILL HERE
C     
C     SEE IF THERE ARE ANY MISSING VALUES IN THE ARRAY.  IF NOT,
C     RETURN TO CALLING PROGRAM.
C
      CALL MINMAX(EGRID,IM,JM,FMIN,FMAX)
      IF (ABS(FMAX-SPVAL).GT.SMALL) RETURN
C     
C     COMPUTE FIELD MEAN, EXCLUDING MISSING POINTS.
C
      NPTS=0
      SUM =0.
C
      DO J=1,JM
      DO I=1,IM
        IF(ABS(EGRID(I,J)-SPVAL).GE.SMALL)THEN
          NPTS=NPTS+1
          SUM =SUM+EGRID(I,J)
        ENDIF
      ENDDO
      ENDDO
      IF(NPTS.EQ.0)THEN
        WRITE(STDOUT,*)'EFILL:  ALL DATA ON EGRID EQUAL SPVAL'
        RETURN
      ENDIF
      AVG=SUM/NPTS
C     
C     REPLACE MISSING VALUES WITH FIELD MEAN.
C
!$omp  parallel do
      DO J=1,JM
      DO I=1,IM
        IF(ABS(EGRID(I,J)-SPVAL).LT.SMALL)EGRID(I,J)=AVG
      ENDDO
      ENDDO
CX      CALL MINMAX(EGRID,IM,JM,FMIN,FMAX)
CX      WRITE(STDOUT,*)'EFILL:  EGRID MIN,MAX,AVG:  ',FMIN,FMAX,AVG
C     
C     END OF ROUTINE.
C     
      RETURN
      END
