      SUBROUTINE LL2EG (YLAT,WLON,XI,YJ)
C$$$  SUBPROGRAM DOCUMENTATION BLOCK
C                .      .    .     
C SUBPROGRAM:    LL2EG       ETA (LAT,LON) TO (I,J)
C   PRGRMMR: TREADON         ORG: W/NP2      DATE: 92-12-23       
C     
C ABSTRACT:
C     GIVEN (LAT,LON) ON A FILLED E-GRID THIS ROUTINE 
C     RETURNS THE CORRESPONDING FLOATING POINT (I,J)
C     OF THIS LOCATION.
C   .     
C     
C PROGRAM HISTORY LOG:
C   ??-??-??  DAVID PLUMMER - SUBROUTINE LL2EG IN ETAPACKC.
C   93-02-26  RUSS TREADON - GENERALIZED LL2EG TO HANDLE
C                            VARIABLE SIZE E-GRIDS.
C     
C USAGE:    CALL LL2EG(YLAT,WLON,XI,YJ)
C   INPUT ARGUMENT LIST:
C     YLAT     - LATITUDE OF (I,J) POINT.
C     WLON     - WEST LONGITUDE OF (I,J) POINT.
C
C   OUTPUT ARGUMENT LIST: 
C     XI       - FLOATING POINT "I" OF (LAT,LON) ON FILLED E-GRID.
C     YJ       - FLOATING POINT "J" OF (LAT,LON) ON FILLED E-GRID.
C     
C   OUTPUT FILES:
C     NONE
C     
C   SUBPROGRAMS CALLED:
C     UTILITIES:
C       NONE
C     LIBRARY:
C       COMMON   - EGRID
C     
C   ATTRIBUTES:
C     LANGUAGE: FORTRAN
C     MACHINE : CRAY C-90
C$$$  
C     
C     
C     DECLARE VARIABLES, COMMON, EQUIVALENCES, AND CONSTANTS.
C
      LOGICAL NORTH
      REAL ALONVT, DLAM, DPHI, LAM, LAM0, PHI0, POLEI, POLEJ
      REAL SINPH0, TANPH0, WLONC, XMESHL, YLATC
C     
C     INCLUDE EGRID SPECIFICATIONS.
      INCLUDE "EGRID.comm"
C
      EQUIVALENCE (YLATC,ALONVT), (DPHI, POLEI)
      EQUIVALENCE (WLONC, POLEJ), (DLAM,XMESHL)
C
      DATA CONV2R/0.017453293/,CONV2D/57.2958/
      DATA EARTHR/6371.2/
C     
C     
C********************************************************************
C     START LL2EG HERE.
C     
C     CONVERT (LAT,LON) TO FLOATING POINT (I,J).
      PHI    = YLAT*CONV2R
      LAM    = WLON*CONV2R
      COSPHI = COS(PHI)
      SINPHI = SIN(PHI)

      X1     = COSPHI*COS(LAM-LAM0)
      X      = COSPH0*X1+SINPH0*SINPHI
      Y      = -COSPHI*SIN(LAM-LAM0)
      Z      = -SINPH0*X1+COSPH0*SINPHI
      BIGPHI = ATAN(Z/(SQRT(X*X+Y*Y)))*CONV2D
      BIGLAM = ATAN(Y/X)*CONV2D
      XI     = (BIGLAM/DLAM)+(IDIM+1)/2.0
      YJ     = (BIGPHI/DPHI)+(JDIM+1)/2.0
C     
C     END OF ROUTINE.
C
      RETURN
      END
