      SUBROUTINE TRNSGD
C$$$  SUBPROGRAM DOCUMENTATION BLOCK
C                .      .    .     
C SUBPROGRAM:    TRNSGD      SET OUTPUT GRID PARAMETERS
C   PRGRMMR: TREADON         ORG: W/NP2      DATE: 92-12-23       
C     
C ABSTRACT:
C     THIS ROUTINE LOADS COMMON BLOCK OUTGRD WITH 
C     OUTPUT GRID SPECIFICATIONS.
C   .     
C     
C PROGRAM HISTORY LOG:
C   ??-??-??  DAVID PLUMMER - SUBROUTINE TRNSCG IN ETAPACKC
C   92-12-23  RUSS TREADON  - MODIFIED ETAPACKC TRNSCG FOR
C                             USE IN ETA POST PROCESSOR.
C   93-06-13  RUSS TREADON  - ADDED LOGIC PROJECTION PARAMETER.
C     
C USAGE:    CALL TRNSGD
C   INPUT ARGUMENT LIST:
C     NONE     
C
C   OUTPUT ARGUMENT LIST: 
C     NONE
C     
C   OUTPUT FILES:
C     STDOUT     - RUN-TIME STANDARD OUT.
C     
C   SUBPROGRAMS CALLED:
C     UTILITIES:
C       NONE
C     LIBRARY:
C       COMMON   - OUTGRD
C                  IOUNIT
C     
C   ATTRIBUTES:
C     LANGUAGE: FORTRAN
C     MACHINE : CRAY C-90
C$$$  
C
C     
C     
C     DECLARE VARIABLES, COMMONS, AND CONSTANTS.
C     
      LOGICAL NORTH
      CHARACTER*6 PROJ
      INTEGER IDIM, JDIM
      REAL ALONVT, GI2, POLEI, POLEJ, RE, XMESHL
C     
C     INCLUDE OUTPUT GRID COMMON BLOCK.
      INCLUDE "OUTGRD.comm"
      INCLUDE "IOUNIT.comm"
C     
C     SET EARTH RADIUS (KM).
      DATA EARTHR/6371.2/
C     
C******************************************************************
C     START TRNSGD HERE.
C     
C     SET COMMON BLOCK CONSTANTS.
C
      RE  = (EARTHR * 1.86603) / XMESHL
      GI2 = RE * RE
C     
      WRITE(STDOUT,*)'TRNSGD:  COMMON BLOCK OUTGRD BELOW'
      WRITE(STDOUT,*)'  PROJ         :  ',PROJ
      WRITE(STDOUT,*)'  NORTH        :  ',NORTH
      WRITE(STDOUT,*)'  ALATVT,ALONVT:  ',ALATVT,ALONVT
      WRITE(STDOUT,*)'  XMESHL       :  ',XMESHL
      WRITE(STDOUT,*)'  POLEI,POLEJ  :  ',POLEI,POLEJ
      WRITE(STDOUT,*)'  IGOUT,JGOUT  :  ',IGOUT,JGOUT
      WRITE(STDOUT,*)'  RE,GI2       :  ',RE,GI2
C     
      RETURN
      END
