#!/bin/csh -x
# Ultima modificacao: TOTA - 13/11/2001 - exclusao da geracao de PS
#                     TOTA - 21/12/2001 - Problemas no "tail -2"
#                     TOTA - 20/02/2002 - retirada rodape (METOP)
#                                         da figuras
#
set DIR_ROOT=`pwd`/..
set DATAI=$1
set Res=$2
set LabRod=$3
set LabRod2=`echo ${3}|awk '{print tolower($1)}'`
set Conf=$4
set DIR_DATA=${5}'/'${Res}'km/'${DATAI}
set DIR_EXE=${DIR_ROOT}'/SkewT'
set DIR_GIF=${DIR_EXE}'/gif/'

if ("$1" == "")then
    set Ano=`date '+%y'` 
    set MESi=`date '+%m'`
    set DATAgs=`date '+%d'`
    set HORA=`date '+%H'`
else
    set Ano=`echo $1 |cut -c1-4`
    set MESi=`echo $1 |cut -c5-6`
    set DATAgs=`echo $1 |cut -c7-8`
    set HORA=`echo $1 |cut -c9-10`

endif

#echo $MESi
set M=('JAN' 'FEB' 'MAR' 'APR' 'MAY' 'JUN' 'JUL' 'AUG' 'SEP' 'OCT' 'NOV' 'DEC')
set MES=$M[$MESi]
#echo $MES
#echo 'dia '$DATAgs
#echo 'hora '$HORA
set DIR_ROOT=`pwd`/..
set DIR_DATA=`${HOME}/bin/caldate.3.0 ${DATAI} + 0hr "${DIR_ROOT}/../../dados/${Conf}/grbctl/${Res}km/${DATAI}"`
set DIR_EXE=${DIR_ROOT}'/SkewT'
set DIR_GIF=${DIR_EXE}'/gif/'
set FIM=`cat ${DIR_EXE}/latlon.txt|wc -l`
@ FIM++
echo $FIM
set cont=1
while ($cont < $FIM)

tail -$cont ${DIR_EXE}/latlon.txt > ${DIR_EXE}/temporario.txt
set cidade=`head -1 ${DIR_EXE}/temporario.txt|awk '{print $1}'`
set estado=`head -1 ${DIR_EXE}/temporario.txt|awk '{print $2}'`
set pais=`head -1 ${DIR_EXE}/temporario.txt|awk '{print $3}'`

set lat=`head -1 ${DIR_EXE}/temporario.txt|awk '{print $4}'`
set lon=`head -1 ${DIR_EXE}/temporario.txt|awk '{print $5}'`
set fct=`head -1 ${DIR_EXE}/temporario.txt|awk '{print $6}'`
set tf=`head -1 ${DIR_EXE}/temporario.txt|awk '{print $7}'`

set arqent=${DIR_DATA}/${LabRod2}${Res}km${DATAI}.ctl
@ cont++
#
#------------------------------------------------------
# Inicio da criacao do GS
#------------------------------------------------------
#
cat <<EOF> ${DIR_EXE}/vttemp_teste.gs
arquivo = '$arqent'
'open 'arquivo
filen = sublin(result,2)
filen = subwrd(filen,8)
'q file'
Sname = sublin(result,1)
Sname1= subwrd(Sname,4)
Sname2= subwrd(Sname,5)
Sname3= subwrd(Sname,6)
Sname4= subwrd(Sname,7)
Sname5= subwrd(Sname,8)
Sname6= subwrd(Sname,9)
Sname7= subwrd(Sname,10)

'q dims'
Lat= ${lat}
Lon= ${lon}
cidade='${cidade}'
titulo='Analise'
tempo=1
mod='Eta ('${Res}' X '${Res}' km)'
ctl=1
'set t '%tempo
'q time'
rec= subwrd(result,3)
hora= substr(rec,1,3)
data= substr(rec,4,9)' '%hora
hora=`${HOME}/bin/caldate.3.0 ${DATAI} + ${fct}hr "hh"`
labw=`${HOME}/bin/caldate.3.0 ${DATAI} + ${fct}hr "sd"`
'set t ${tf}'
'q file'
rec=sublin(result,5)
Nlev=subwrd(rec,9)
lon_new=${lon}
'set lat ${lat}'
'set lon '%lon_new
'd topo'
rec=sublin(result,1)
top=subwrd(rec,4)
if (top<1)
top=0
endif
cidade1= '(Alt: '%top' m)'

*-----------------------------------------------------
* Get surface pressure
*-----------------------------------------------------
   'd pslc'
   surfp= subwrd(result,4)
   say "surfp "surfp
   'set lev 'surfp
   'q dims'
   rec=sublin(result,4) 
   zstart=subwrd(rec,9)

*'set z 1 'Nlev
'set lev 1000 100'
'q time'
tempo=subwrd(result,3)

'define tabc=temp.'filen'-273.15'
'define dewp=(temp-(35*(-log10(umrl/100))))-273.15'
'enable print ${DIR_EXE}/skewt.gmf'
  'set gxout contour'
  'set lev 1050 100'
  'set xlopts 1 4 .15'
  'set ylopts 1 4 .15'
rec = plotskew(tabc,dewp,zstart)

*-----------------------------coloca os titulos
  'set strsiz 0.22'
  'set string 8'
  'draw title  Skew T - Log P'
*  'draw string 7.2 7.8 Skew T - Log P'
  'set strsiz 0.15'
  'set string 1'
  'draw string 8.5 7.35 Perfil de T e Td'
  'draw string 8.0 7.0 Local: '
  'draw string 8.0 6.4 Lat/Lon: '
  'draw string 8.0 6.1 Modelo: '
  'draw string 8.0 5.8 Data: '
  'draw string 8.0 5.5 fct: '
  'draw string 8.5 7.35 Perfil de T e Td'
  'set strsiz 0.10'
  'draw string 8.8 7.0 '%cidade
  'draw string 8.8 6.7 '%cidade1
  'draw string 9.0 6.4 '%Lat' '%Lon
  'draw string 9.0 6.1 '%mod
  'draw string 8.8 5.8 '%data
  'draw string 8.8 5.5 '%hora
  'draw string 9.2 5.5 '%labw
  'set strsiz 0.15'
  'set string 15'
  'draw string 8.0 7.0 Local:'
  'draw string 8.0 6.4 Lat/Lon:'
  'draw string 8.0 6.1 Modelo:'
  'draw string 8.0 5.8 Data:'
  'draw string 8.0 5.5 fct:'
rec = plotwind(u,v)
*-----------------------------------------------desenha linhas
  'set line  2 1 6'
  'draw line 8.2 1.1 8.6 1.1'
  'set line 11 1 6'
  'draw line 8.2 0.8 8.6 0.8'
  'set line  3 1 6'
  'draw line 8.2 0.5 8.6 0.5'
  'set strsiz 0.10'
  'set string 1'
  'draw string 8.7 1.05 Temperatura'
  'draw string 8.7 0.80 Temp. Pto. Orvalho'
  'draw string 8.7 0.55 Trajetoria da parcela'
  'set strsiz 0.11'
  'set string 15'
  'draw string 9.0 0.1 IPMet/CPTEC/INPE'
*  'draw string 0.1 0.1 Fonte: INMET'
  'print'
  'disable print'
  '!gxgif -r -x 480 -y 380 -i ${DIR_EXE}/skewt.gmf -o ${DIR_GIF}/${cidade}+00${fct}.gif'
'quit'
return 
*************************************************************************
function plotskew(sndtemp,snddewp,zstart)
*************************************************************************

P1 = 1000
T1 = -40

P2 = 1000
T2 = 40

P3 = 200
T3 = -50

* ------------------- Contour Intervals / Levels --------------------------
*
* All variables below are contour intervals/levels for diagram
*
* Thetaint = interval for potential temperature lines
* Thetwint = interval for moist pseudo adiabats
* tempint  = interval for temperature lines
* wsclevs  = contour LEVELS for mixing ratio lines
*
*
thetaint = 10
thetwint = 5
tempint = 10
wsclevs = "1 1.5 3 4 6 8 10 12 16 20 24 28 32 36 40"
*
*
* ------------------------ Output Options --------------------------------
*
* All variables below are logical .. 1=yes, 0=no
*
* DrawBarb = Draw wind barbs along right side of plot
* DrawThet = Draw dry adiabats
* DrawThtw = Draw moist pseudo-adiabats
* DrawTemp = Draw temperature lines 
* DrawMix  = Draw mixing ratio lines
* DrawTSnd = Draw temperature sounding
* DrawDSnd = Draw dewpoint sounding
* DrawPrcl = Draw parcel path from LCL upward
* DrawIndx = Display stability indices & CAPE
* DrawHodo = Draw hodograph
* DrawPLev = Draw Pressure Levels 
* DrawZLev = Draw Height Levels (*not* actual height...height above MSL)

DrawThet = 1
DrawThtw = 1
DrawTemp = 1
DrawMix  = 1
DrawTSnd = 1
DrawDSnd = 1
DrawPrcl = 1
DrawIndx = 1
DrawPLev = 1
DrawZLev = 0

*
*---------------- Color Options ------------------------------------------
*
* ThetCol = Color of dry adiabats         (15=cinza)
* TempCol = Color of temperature lines    (15=cinza)
* MixCol  = Color of mixing ratio lines   (10=amarelo/verde)
* ThtwCol = Color of moist adiabats       (12=amarelo escuro)
* TSndCol = Color of Temperature Sounding ( 2=vermelho) 
* DSndCol = Color of Dewpoint Sounding    (11=azul medio)
* PrclCol = Color of parcel trace         ( 3=verde)
* BarbCol = Color of wind barbs
* HodoCol = Color of hodograph trace

ThetCol = 15
TempCol = 15
MixCol =  10
ThtwCol = 12
TSndCol = 2 
DSndCol = 11
PrclCol = 3

*
*-------------------- Line Style Options ------------------------------------
*
* GrADS Styles: 1=solid;2=long dash;3=short dash;4=long,short dashed;
*               5=dotted;6=dot dash;7=dot dot dash
*
* ThetLine = Line Style of dry adiabats
* TempLine = Line Style of temperature lines
* MixLine = Line Style of mixing ratio lines
* ThtwLine = Line Style of moist adiabats
* TSndLine = Line Style of Temperature Sounding
* DSndLine = Line Style of Dewpoint Sounding
* PrclLine = Line Style of parcel trace
* HodoLine = Line Style of hodograph trace
*

ThetLine = 1
TempLine = 1
MixLine = 5
ThtwLine = 3
TSndLine = 1
DSndLine = 2
PrclLine = 3

*
*------------------- Line Thickness Options------------------------------------
* GrADS Line Thickness: increases with increasing number. Influences hardcopy 
*                       output more strongly than screen output.
*
*
* ThetThk = Line Thickness of dry adiabats
* TempThk = Line Thickness of temperature lines
* MixThk = Line Thickness of mixing ratio lines
* ThtwThk = Line Thickness of moist adiabats
* TSndThk = Line Thickness of temperature sounding
* DSndThk = Line thickness of dewpoint sounding
* PrclThk = Line thickness of parcel trace
* HodoThk = Line thickness of hodograph trace

ThetThk = 3
TempThk = 3
MixThk = 3
ThtwThk = 3
TSndThk = 8 
DSndThk = 8
PrclThk = 7  

* !!!!! YOU SHOULD NOT NEED TO CHANGE ANYTHING BELOW HERE !!!!!
****************************************************************************

If (snddewp = -1) 
  DrawDSnd = 0
  DrawPrcl = 0
  DrawIndx = 0
Endif

If (sndtemp = -1)
  DrawTSnd = 0
  DrawPrcl = 0
  DrawIndx = 0
Endif
  
"q gxinfo"
rec=sublin(result,2)
xsize=subwrd(rec,4)

If (xsize = 11) 
   PageType = "Landscape"
Else
   PageType = "Portrait"
Endif
  

*-------------------------------------------
* grab user-specified environment dimensions
*-------------------------------------------

"q dims"
rec=sublin(result,2)
xval=subwrd(rec,9)
rec=sublin(result,3)
yval=subwrd(rec,9)
rec=sublin(result,4)
pmax=subwrd(rec,6)
pmin=subwrd(rec,8)
zmin=subwrd(rec,11)
zmax=subwrd(rec,13)
rec=sublin(result,5)
tval=subwrd(rec,9)
*------------------------------------------------------
* calculate constants determining slope/shape of diagram
* based on temp/pressure values given by user
*-------------------------------------------------------

"set x 2"
"set y 2"
"set z 1"
"set t 1"
"set gxout stat"
"define m1 = ("T1"+"T2"-2*"T3") / (2*log10("P2"/"P3"))"
"d m1"
rec=sublin(result,8)
m1=subwrd(rec,4)
"define m2 = ("T2"-"T3"-m1*log10("P2"/"P3"))/50"
"d m2"
rec=sublin(result,8)
m2=subwrd(rec,4)
"define m3 = ("T1"-m1*log10("P1"))"
"d m3"
rec=sublin(result,8)
m3=subwrd(rec,4)

"set z "zstart" "zmax           
"set zlog on"
"set xlab off"

*-------------------------------------------------
* perform coordinate transformation to Skew-T/LogP
*-------------------------------------------------

"set gxout stat"
"set x "xval
"set y "yval
"set t "tval
"define tempx=("sndtemp"-m1*log10(lev)-m3)/m2"
"define dewpx=("snddewp"-m1*log10(lev)-m3)/m2"

If (PageType = "Portrait") 
   "set parea 0.5 7 0.75 10.5"
Else
   "set parea 0.7 6.5 0.5 8"
Endif
  
"set axlim 0 100"
"set lon 0 100"
"set grid on 1 1"

"set z "zmin " " zmax
"set lon 0 100"
"set clevs -900"
"set gxout contour"

*-------------------------------------
* Draw pressure lines 
*-------------------------------------

If (DrawPLev = 0) 
   "set ylab off"
Else
   "set ylab on"
Endif

"d lon"

*-------------------------------------
* Draw height lines (height above MSL)
*-------------------------------------

If (DrawZLev = 1)
   "set gxout stat"
   "define minht=30.735*(1-pow("pmax"/1013.26,0.287))"
   "d minht"
   rec=sublin(result,8)
   minht=subwrd(rec,5)
   minht=int(minht+0.5)
   "define maxht=30.735*(1-pow("pmin"/1013.26,0.287))"
   "d maxht"
   rec=sublin(result,8)
   maxht=subwrd(rec,5)
   maxht=int(maxht+0.5)
   "set gxout stat"
   zcount=minht        
   while (zcount < maxht) 
      "define plev=1013.26*pow((1-"zcount"/30.735),3.4843)"
      "d plev"
      rec=sublin(result,8)
      plev=subwrd(rec,5)
      "q w2xy 0 "plev 
      rec=sublin(result,1)
      xloc=subwrd(rec,3)
      yloc=subwrd(rec,6)
      "q w2xy 100 "plev
      rec=sublin(result,1)
      xloc2=subwrd(rec,3)
      "set line 1 3 1"
      "draw line " xloc " " yloc " " xloc2 " " yloc
      "draw string 0 "yloc" "zcount
      zcount=zcount+1
   endwhile
Endif


*-----------------------
* Plot temperature lines 
*-----------------------

If (DrawTemp = 1)
   "set z "zmin " " zmax
   "set line "TempCol " " TempLine " "TempThk
   "set string 1"
   "set gxout stat"
   maxtline=GetTemp(100,pmax,m1,m2,m3)
   mintline=GetTemp(0,pmin,m1,m2,m3)

   maxtline=tempint*int(maxtline/tempint)
   mintline=tempint*int(mintline/tempint)

   tloop=mintline
   While (tloop <= maxtline) 
       Botxtemp=GetXLoc(tloop,pmax,m1,m2,m3)
       "q w2xy "Botxtemp " " pmax
       rec=sublin(result,1)
       Botxloc=subwrd(rec,3)
       Botyloc=subwrd(rec,6)
       Topxtemp=GetXLoc(tloop,pmin,m1,m2,m3)
        "q w2xy "Topxtemp " " pmin
       rec=sublin(result,1)
       Topxloc=subwrd(rec,3)
       Topyloc=subwrd(rec,6)
       If (Botxtemp <= 100 | Topxtemp <= 100) 
          If (Topxtemp > 100)
             Slope=(Topyloc-Botyloc)/(Topxtemp-Botxtemp)
             b=Topyloc-Slope*Topxtemp
             Topyloc=Slope*100+b
             "q w2xy 100 " pmin
             rec=sublin(result,1)
             Topxloc=subwrd(rec,3)
          Endif
          If (Botxtemp < 0)
             Slope=(Topyloc-Botyloc)/(Topxtemp-Botxtemp)
             b=Botyloc-Slope*Botxtemp
             Botyloc=b
             "q w2xy 0 " pmin
             rec=sublin(result,1)
             Botxloc=subwrd(rec,3)
          Else
             "set strsiz 0.15"
             "draw string " Botxloc-0.2 " " Botyloc-0.23 " " tloop
          Endif
          "draw line "Botxloc " " Botyloc " " Topxloc " " Topyloc
       Endif
       tloop=tloop+tempint
   EndWhile
Endif


*------------------
* Plot dry adiabats
*------------------

If (DrawThet = 1)
   temp=GetTemp(100,pmin,m1,m2,m3)
   maxtheta=GetTheta(temp,pmin)
   maxtheta=thetaint*int(maxtheta/thetaint)
   temp=GetTemp(0,pmax,m1,m2,m3)
   mintheta=GetTheta(temp,pmax)
   mintheta=thetaint*int(mintheta/thetaint)
   
   "set lon 0 100"
   "set y 2"
   "set z 1"
   "set gxout stat"
   tloop=mintheta
   While (tloop <= maxtheta)
     "set line "ThetCol" "ThetLine " "ThetThk
     PTemp=LiftDry(tloop,1000,pmin,m1,m2,m3,1,pmin,pmax)     
     tloop=tloop+thetaint
   Endwhile
Endif

*------------------------
* Plot mixing ratio lines
*------------------------

If (DrawMix = 1)
   "set z "zmin " " zmax
   "set cint 1"
   "set line "MixCol" " MixLine " "MixThk
   cont = 1
   mloop=subwrd(wsclevs,1)
   count = 1
   While (cont = 1) 
       "set gxout stat"
       "define BotCoef=log("mloop"*"pmax"/3801.66)"
       "d BotCoef"
       rec=sublin(result,8)
       BotCoef=subwrd(rec,4)
       BotTval=-245.5*BotCoef/(BotCoef-17.67)
       Botxtemp=GetXLoc(BotTval,pmax,m1,m2,m3)
       "q w2xy "Botxtemp " " pmax
       rec=sublin(result,1)
       Botxloc=subwrd(rec,3)
       Botyloc=subwrd(rec,6)
       "define TopCoef=log("mloop"*"pmin"/3801.66)"
       "d TopCoef"
       rec=sublin(result,8)
       TopCoef=subwrd(rec,4)
       TopTval=-245.5*TopCoef/(TopCoef-17.67)
       Topxtemp=GetXLoc(TopTval,pmin,m1,m2,m3)
       "q w2xy "Topxtemp " " pmin
       rec=sublin(result,1)
       Topxloc=subwrd(rec,3)
       Topyloc=subwrd(rec,6)
       "set string "MixCol 
       "set strsiz 0.12"
       If (Botxtemp <= 100 | Topxtemp <= 100) 
          If (Topxtemp > 100)
             Slope=(Topyloc-Botyloc)/(Topxtemp-Botxtemp)
             b=Topyloc-Slope*Topxtemp
             Topyloc=Slope*100+b
             "q w2xy 100 " pmin
             rec=sublin(result,1)
             Topxloc=subwrd(rec,3)
             "draw string " Topxloc+0.05 " " Topyloc  " " mloop
          Else
             If (PageType = "Landscape")  
                "draw string " Topxloc " " Topyloc+0.1 " " mloop
             Endif
          Endif
          If (Botxtemp < 0)
             Slope=(Topyloc-Botyloc)/(Topxtemp-Botxtemp)
             b=Botyloc-Slope*Botxtemp
             Botyloc=b
             "q w2xy 0 " pmin
             rec=sublin(result,1)
             Botxloc=subwrd(rec,3)
          Endif
          "draw line "Botxloc " " Botyloc " " Topxloc " " Topyloc
       Endif
       count=count+1
       mloop=subwrd(wsclevs,count)
       If (mloop = "" | count > 50) 
          cont = 0
       Endif
   EndWhile
Endif

*-----------------------------
* Plot moist (pseudo) adiabats
*-----------------------------

If (DrawThtw = 1)
   "set lon 0 100"
   "set y 2"
   "set z 1"
   "set gxout stat"
   tloop=80
   While (tloop > -80)
     "set line "ThtwCol" "ThtwLine " "ThtwThk
     PTemp=LiftWet(tloop,1000,pmin,m1,m2,m3,1,pmin,pmax)     
     tloop=tloop-thetwint
   Endwhile
Endif

*-----------------------------------------------------
* Plot transformed user-specified temperature sounding
*-----------------------------------------------------

If (DrawTSnd = 1)
   "set gxout line"
   "set x "xval
   "set y "yval
   "set z "zmin" "zmax     
   "set ccolor "TSndCol
   "set cstyle "TSndLine
   "set cmark 0"
   "set cthick "TSndThk 
   "d tempx"
Endif

*---------------------------------------------------
* Plot transformed user-specified dewpoint sounding
*---------------------------------------------------

If (DrawDSnd = 1)
   "set gxout line"
   "set x "xval
   "set y "yval
   "set z "zmin" "zmax
   "set cmark 0"
   "set ccolor "DSndCol
   "set cstyle "DSndLine
   "set cthick "DSndThk
   "d dewpx"
Endif

*----------------------------------------
* Determine lowest level of reported  data
*----------------------------------------

If (DrawTSnd = 1 & DrawDSnd = 1)
   "set gxout stat"
*   zz=1
   zz=zstart
   temp=-999
   While (abs(temp) > 130 & zz <= zmax) 
      "set z "zz
      "set x "xval
      "set y "yval 
      "set t "tval
      "d "sndtemp
      rec=sublin(result,8)
      temp=subwrd(rec,4)
      if (abs(temp) > 130) 
        zz=zz+1
      endif
   Endwhile
   "q gr2w 50 "zz
   rec=sublin(result,1)
   Plev=subwrd(rec,6)
   "d "snddewp
   rec=sublin(result,8)
   dewp=subwrd(rec,4)

*------------------------------------------
* Calculate temperature and pressure of LCL
*------------------------------------------

   TLcl=Templcl(temp,dewp)
   Plcl=Preslcl(temp,dewp,Plev)
Endif

*----------------------------------------------------------
* Plot parcel path from surface to LCL and up moist adiabat
*----------------------------------------------------------

If (DrawPrcl = 1)
   If (PageType = "Portrait")
      xloc=7.15
   Else
      xloc=6.65
   Endif
   "q w2xy 1 "Plcl
   rec=sublin(result,1)
   yloc=subwrd(rec,6)
   "set strsiz 0.10"
   "set string 6"
   If (Plcl < pmax) 
      "draw string "xloc" "yloc" NCL"
      "set line 1 1 1"
      "draw line "xloc-0.15" "yloc" "xloc-0.05" "yloc
   Endif
   "set lon 0 100"
   "set gxout stat"
   "set line "PrclCol" "PrclLine " " PrclThk
   PTemp=LiftDry(temp,Plev,Plcl,m1,m2,m3,1,pmin,pmax)
   Ptemp=LiftWet(TLcl,Plcl,pmin,m1,m2,m3,1,pmin,pmax)
Endif

*--------------------------------
* Draw stability indices and CAPE
*--------------------------------

If (DrawIndx = 1) 
   "set strsiz 0.19"
   "set x "xval
   "set y "yval
   "set t "tval
   "set gxout grid"
*
   "set lev 850"
   "d "sndtemp
   Temp850=subwrd(result,4)
   "d "snddewp
   Dewp850=subwrd(result,4)
*
   "set lev 700"
   "d "sndtemp
   Temp700=subwrd(result,4)
   "d "snddewp
   Dewp700=subwrd(result,4)
*
   "set lev 500"
   "d "sndtemp
   Temp500=subwrd(result,4)
   "d "snddewp
   Dewp500=subwrd(result,4)
*
   K=Temp850+Dewp850+Dewp700-Temp700-Temp500
   tt=Temp850+Dewp850-2*Temp500
   PTemp=LiftWet(TLcl,Plcl,500,m1,m2,m3,0)
   "define SLI="Temp500"-"PTemp""
   "d SLI"
   rec=sublin(result,8)
   SLI=subwrd(rec,4)
   Pos=CAPE(TLcl,Plcl,200,sndtemp,zmax)
   If (PageType = "Portrait") 
      "draw string 0.5 10.8 K  = " int(K)        
      "draw string 0.5 10.6 TT = "  int(tt)          
      "draw string 2.0 10.8 SLI = " int(SLI)        
      "draw string 2.0 10.6 CAPE= " int(Pos)        
   Else
      "set strsiz 0.15"
      "set string 1"
      "draw string 8.00 4.55 Indices de Estabilidade"
      "draw string 8.90 4.30 Atmosferica"
      "set strsiz 0.14"
      "set string 13"
      "draw string 8.60 4.00 Indice K = " int(K)        
      "draw string 8.60 3.75 Indice TT = " int(tt)          
      "draw string 8.60 3.50 Indice SLI = " int(SLI)        
      "draw string 8.60 3.00 Valor CAPE = " int(Pos)         
   Endif
Endif

*------------------------------------------
* Reset environment to original dimensions
*------------------------------------------

"set t "tval
"set x "xval 
"set y "yval 
"set z "zmin " "zmax

Return

*************************************************************************
function Templcl(temp,dewp)

*------------------------------------------------------
* Calculate the temp at the LCL given temp & dewp in C
*------------------------------------------------------

"set gxout stat"
tempk=temp+273.15
dewpk=dewp+273.15
Parta=1/(dewpk-56)
"define Partb=log("tempk"/"dewpk")/800"
"d Partb"
rec=sublin(result,8)
Partb=subwrd(rec,4)
Tlcl=1/(Parta+Partb)+56
return(Tlcl-273.15)

**************************************************************************

function Preslcl(temp,dewp,pres)

*-------------------------------------------------------
* Calculate press of LCL given temp & dewp in C and pressure
*-------------------------------------------------------

"set gxout stat"
Tlcl=Templcl(temp,dewp)
Tlclk=Tlcl+273.15
tempk=temp+273.15
"define theta="tempk"*pow(1000.0/"pres",0.286)"
"d theta"
rec=sublin(result,8)
theta=subwrd(rec,4)
"define plcl=1000.0*pow("Tlclk"/"theta",3.48)"
"d plcl"
rec=sublin(result,8)
plcl=subwrd(rec,4)
return(plcl)

**************************************************************************
function LiftWet(startt,startp,endp,m1,m2,m3,display,Pmin,Pmax)

*--------------------------------------------------------------------
* Lift a parcel moist adiabatically from startp to endp.
* Init temp is startt in C.  If you wish to see the parcel's
* path plotted, display should be 1.  Returns temp of parcel at endp.
*--------------------------------------------------------------------

temp=startt
pres=startp
cont = 1
delp=10
"set gxout stat"
While (pres >= endp & cont = 1) 
    If (display = 1) 
       "define xtemp=("temp"-m1*log10("pres")-m3)/m2"
       "d xtemp"
       rec=sublin(result,8)
       xtemp=subwrd(rec,4)
       "q w2xy "xtemp" "pres
       rec=sublin(result,1)
       xloc=subwrd(rec,3)
       yloc=subwrd(rec,6)
       If (xtemp < 0 | xtemp > 100)
          cont=0
       Else
          If (pres >= Pmin & pres < Pmax & pres < startp)  
             "draw line "xold" "yold" "xloc" "yloc 
          Endif
       Endif
    Endif
    pres=pres-delp
    xold=xloc
    yold=yloc
    lapse=gammaw(temp,pres,100)
    temp=temp-100*delp*lapse                  
EndWhile
return(temp)


**************************************************************************
function LiftDry(startt,startp,endp,m1,m2,m3,display,Pmin,Pmax)

*--------------------------------------------------------------------
* Lift a parcel dry adiabatically from startp to endp.
* Init temp is startt in C.  If you wish to see the parcel's
* path plotted, display should be 1.  Returns temp of parcel at endp.
*--------------------------------------------------------------------

pres=startp
cont = 1
delp=10
While (pres >= endp & cont = 1) 
    "define tempval = ("startt"+273.15)*pow(1.0*"pres"/"startp",0.286)-273.15"
    "d tempval"
    rec=sublin(result,8)
    temp=subwrd(rec,4)
    If (display = 1) 
       "set gxout stat"
       xtemp=GetXLoc(temp,pres,m1,m2,m3)
       "q w2xy "xtemp" "pres
       rec=sublin(result,1)
       xloc=subwrd(rec,3)
       yloc=subwrd(rec,6)
       If (xtempold > 0 & xtempold < 100 & xtemp > 0 & xtemp < 100) 
          If (pres >= Pmin & pres < Pmax & pres < startp)  
             "draw line "xold" "yold" "xloc" "yloc 
          Endif
       Endif
    Endif
    xold=xloc
    xtempold=xtemp
    yold=yloc
    pres=pres-delp
EndWhile
return(temp)

**************************************************************************
function CAPE(startt,startp,endp,sndtemp,zmax)

*---------------------------------------------------------------------
* Returns all postive area above LCL.  
* parcel is lifted from LCL at startt,startp and is halted
* at endp.
*---------------------------------------------------------------------

Pcltemp=startt
pres=startp
cont = 1
delp=10
Pos=0
Neg=0

While (pres >= endp & cont = 1)
   EnvTemp=interp(sndtemp,sndtemp,pres-delp,zmax)
   Pcltemp=Pcltemp-100*delp*gammaw(Pcltemp,pres,100)  
   "define Val=(287*log("pres"/("pres"-"delp"))*("Pcltemp"-"EnvTemp"))"
   "d Val"
   rec=sublin(result,8)
   Val=subwrd(rec,4)
   If (abs(EnvTemp) < 130 & abs(Pcltemp) < 130) 
      If (Val > 0) 
         Pos=Pos+Val
      Else
         Neg=Neg+Val
      Endif
   Endif
   pres=pres-delp
Endwhile

return(Pos)

***************************************************************************
function gammaw(tempc,pres,rh)

*-----------------------------------------------------------------------
* Function to calculate the moist adiabatic lapse rate (deg C/Pa) based
* on the temperature, pressure, and rh of the environment.
*----------------------------------------------------------------------

tempk=tempc+273.15
"define es=6.112*exp(17.67*"tempc"/("tempc"+243.5))"
"d es"
rec=sublin(result,8)
es=subwrd(rec,4)
ws=0.622*es/(pres-es)
w=rh*ws/100
tempv=tempk*(1.0+0.6*w)

A=1.0+2.5e6*ws/(287*tempk)
B=1.0+0.622*2.5e6*2.5e6*ws/(1004*287*tempk*tempk)
Density=100*pres/(287*tempv)
lapse=(A/B)/(1004*Density)
return(lapse)

*************************************************************************
function interp(array,temparr,pres,zmax)

*------------------------------------------------------------------------
* Interpolate inside array for pressure level pres.  
* Returns estimated value of array at pressure pres.
*------------------------------------------------------------------------

"set lev "pres
altpres=subwrd(result,4)
"q dims"
rec=sublin(result,4)
zlev=subwrd(rec,9)

If (altpres > pres) 
   zmin=zlev+1
Else
   zmin=zlev
Endif
 
"set z "zmin
rec=sublin(result,1)
PAbove=subwrd(rec,4)
"d "array"(lev="PAbove")"
rec=sublin(result,8)
VAbove=subwrd(rec,4)
"d "temparr"(lev="PAbove")"
rec=sublin(result,8)
TAbove=subwrd(rec,4)
"set z "zmin-1
rec=sublin(result,1)
PBelow=subwrd(rec,4)
"d "array"(lev="PBelow")"
rec=sublin(result,8)
VBelow=subwrd(rec,4)
"d "temparr"(lev="PBelow")"
rec=sublin(result,8)
TBelow=subwrd(rec,4)

If (abs(TAbove) < 130 & abs(TBelow) < 130 & zmin < zmax) 
    found = 1
Else
    found = 0
Endif
       
If (found = 1)
   "define MeanT=(log10("PAbove")*"TAbove"+log10("PBelow")*"TBelow")/(log10("PAbove"*"PBelow"))"
   "d MeanT"
   rec=sublin(result,8)
   MeanT=subwrd(rec,4)+273.15
   "define LayerD=287*"MeanT"*log("PBelow"/"PAbove")/9.8"
   "d LayerD"
   rec=sublin(result,8)
   LayerD=subwrd(rec,4)
   "define DZ=287*"MeanT"*log("PBelow"/"pres")/9.8"
   "d DZ"
   rec=sublin(result,8)
   DZ=subwrd(rec,4)
   DelV=VAbove-VBelow
   Vest=VBelow+DZ*DelV/LayerD
Else  
   Vest=-9999.0
Endif

Return(Vest)

*************************************************************************

function GetXLoc(temp,pres,m1,m2,m3)

*-------------------------------------------------
* Get x-location on skew-t based on temp, pressure
*-------------------------------------------------

"set gxout stat"
"define xloc=("temp"-"m1"*log10("pres")-"m3")/"m2" "
"d xloc"
rec=sublin(result,8)
xloc=subwrd(rec,4)
return(xloc)

*************************************************************************
 
function GetTemp(xloc,pres,m1,m2,m3) 

*------------------------------------------------- 
* Return temperature at location given by xloc,pres
*-------------------------------------------------

"set gxout stat"
"define tempval = m1*log10("pres")+m2*"xloc"+m3"
"d tempval"
rec=sublin(result,8)
tempval=subwrd(rec,4)
return(tempval)

**************************************************************************

function GetTheta(temp,pres)         

*---------------------------------------------------
* Calculate theta for a given temperature and pressure
*---------------------------------------------------

"set gxout stat"
"define theta = ("temp"+273.15)*pow(1000/"pres",0.286)-273.15"
"d theta"
rec=sublin(result,8)
theta=subwrd(rec,4)
return(theta)


*************************************************************************

function int(i0)
  i=0
  while(i<12)
    i=i+1
    if(substr(i0,i,1)='.')
      i0=substr(i0,1,i-1)
      break
    endif
  endwhile
return(i0)

*************************************************************************

function abs(i)

  if (i < 0) 
     absval=-i
  else 
     absval=i
  endif

return(absval)

function plotwind(uvel,vvel)
'set parea 7.2 7.95 0.5 8'
'set lev 1050 100'
'set xlab off'
'set ylab off'
'set frame off'
'set cthick 3'
'set gxout barb'
'set lat ${lat}'
lon_new=${lon}
'set lon '%lon_new
lonp=subwrd(result,4)
lonn=lonp-0.0015
lonm=lonp+0.0015
'set lon '%lonn'  '%lonm
'd uvel*1.94384;vvel*1.94384;mag(uvel*1.94384,vvel*1.94384)'
return

EOF
/usr/bin/grads -blc "run ${DIR_EXE}/vttemp_teste.gs"
end
