DIR_Eta='DIRWRK'
DIR_EXEC=DIR_Eta'/scripts'
DIR_GMP=DIR_Eta'/gmp'
DIR_GIF=DIR_Eta'/gif/DATE'

'!mkdir -p 'DIR_GIF''

int=FIGINT
labw='SSS'
'open ARQCTL.ctl'
'set time ZZ'
'q dims'
rec=sublin(result,5)
ti=subwrd(rec,9)
say ti
'run 'DIR_EXEC'/rgb.gs'
'set map 1 1 6 '
'set mpdset brmap_hires'
'set grads off'
xfig=430
yfig=560
************  NEW PLOT ********

*    PRESSA AO NIVEL DO MAR

'enable print 'DIR_GMP'/SLPDATE+TT.gmt'
'set strsiz 0.14'
'set string 1 c 5 '
'draw string 5.2  8.3   IPMET/CPTEC/INPE/MCT - Modelo Meso Eta 10km'
'draw string 5.2  8.1  Previs`6a`0o DATE+TTh, v`6b`0lida para DTLEUTC ('labw')'
'draw string 5.2  7.9 Press`6a`0o ao N.M.M. (hPa) '
'set grads off'
'set lev 1000'
'set gxout shaded'
'set clevs 1012 1013 1014 1015 1016 1017 1018 1019 1020 1021 1022 1023 1024'
'd pslm'
'run cbar.gs'
'set gxout contour'
'set cint 1'
'set cthick 3'
'set ccols 0'
'd pslm'
'print'
'disable print 'DIR_GMP'/SLPDATE+TT.gmt'
'!gxgif   -r   -i 'DIR_GMP'/SLPDATE+TT.gmt -o 'DIR_GIF'/SLP+TT.gif'
'!rm 'DIR_GMP'/SLPDATE+TT.gmt'
'clear'

************  NEW PLOT ********

* OROGRAFIA E VENTO EM 10 METROS

'enable print 'DIR_GMP'/V10DATE+TT.gmt'
'set strsiz 0.14'
'set string 1 c 5 '
'draw string 5.2  8.3   IPMET/CPTEC/INPE/MCT - Modelo Meso Eta 10km'
'draw string 5.2  8.1  Previs`6a`0o DATE+TTh, v`6b`0lida para DTLEUTC ('labw')'
'draw string 5.2  7.9 Orografia (m)  e Vento em 10 m'
'set grads off'
'set gxout grfill'
*'set lev 950'
'set clevs  200 250 300 350 400 450 500 700 1000 '
'set ccols  0 91 92 93 94 95 96 97 98 99'
*'set clevs  500 1000 3500'
*'set ccols 0 81 83 84'
'set grads off'
'd topo'
'run cbar.gs'
*'set lev 950'
'set gxout barb'
'd 1.94384*skip(u10m,5);1.94384*v10m'
'print'
'disable print 'DIR_GMP'/V10DATE+TT.gmt'
'!gxgif   -r   -i 'DIR_GMP'/V10DATE+TT.gmt -o 'DIR_GIF'/V10+TT.gif'
'!rm 'DIR_GMP'/V10DATE+TT.gmt'
'clear'

** VENTO E JATO EM 250 hPa

'enable print 'DIR_GMP'/JT2DATE+TT.gmt'
'set strsiz 0.14'
'set string 1 c 5 '
'draw string 5.2 8.4   IPMET/CPTEC/INPE/MCT - Modelo Meso Eta 10km'
'draw string 5.2 8.1  Previs`6a`0o DATE+TTh, v`6b`0lida para DTLEUTC ('labw')'
'draw string 5.2 7.9  Vento e Jato em 250 hPa (n`6p`0s)'
'set grads off'
'set gxout grfill'
'set lev 250'
'set cmin 50'
'set cint 10'
'd mag(uvel*1.94384,vvel*1.94384)'
'run  cbar.gs'
'set gxout contour'
'set lev 250'
'set cstyle 1'
'set cmin 50'
'set cint 10'
'd mag(uvel*1.94384,vvel*1.94384)'
'set ccolor 1'
'set gxout barb'
'd 1.94384*skip(uvel,7);1.94384*vvel'
'print'
'disable print 'DIR_GMP'/JT2DATE+TT.gmt'
'!gxgif   -r   -i 'DIR_GMP'/JT2DATE+TT.gmt -o 'DIR_GIF'/JT2+TT.gif'
'!rm 'DIR_GMP'/JT2DATE+TT.gmt'
'c'


***********  NEW PLOT  *********

* LINHAS DE CORRENTE EM 850 hPa 

'enable print 'DIR_GMP'/ST8DATE+TT.gmt'
'set strsiz 0.14'
'set string 1 c 5 '
'draw string 5.2  8.3   IPMET/CPTEC/INPE/MCT - Modelo Meso Eta 10km'
'draw string 5.2  8.1  Previs`6a`0o DATE+TTh, v`6b`0lida para DTLEUTC ('labw')'
'draw string 5.2  7.9  Linhas de Corrente e Magnitude do Vento (m/s) em 850 hPa'
'set grads off'
'set cthick 3' 
'set gxout stream'
'set clevs 1 2 4 6 8 10 12 14 16 18 20 22 24'
'set ccols 0 9 14 4 11 5 13 3 10 7 12 8 2 6'
'set lev 850'
'd uvel;vvel;mag(uvel,vvel)'
'run cbar.gs'
'print'
'disable print 'DIR_GMP'/ST8DATE+TT.gmt'
'!gxgif   -r   -i 'DIR_GMP'/ST8DATE+TT.gmt -o 'DIR_GIF'/ST8+TT.gif'
'!rm 'DIR_GMP'/ST8DATE+TT.gmt'
'c'

***********  NEW PLOT  *********

* LINHAS DE CORRENTE EM 500 hPa

'enable print 'DIR_GMP'/ST5DATE+TT.gmt' 
'set strsiz 0.14'
'set string 1 c 5 '
'draw string 5.2  8.3   IPMET/CPTEC/INPE/MCT - Modelo Meso Eta 10km'
'draw string 5.2  8.1  Previs`6a`0o DATE+TTh, v`6b`0lida para DTLEUTC ('labw')'
'draw string 5.2  7.9  Linhas de Corrente e Magnitude do Vento (m/s) em 500 hPa'
'set grads off'
'set gxout stream'
'set cthick 3' 
'set lev 500'
'set clevs 1 5 10 15 20 25 30 35 40 45 50 55 60'
'set ccols 0 9 14 4 11 5 13 3 10 7 12 8 2 6'
'd uvel;vvel;mag(uvel,vvel)'
'run cbar.gs'
'print'
'disable print 'DIR_GMP'/ST5DATE+TT.gmt'
'!gxgif   -r   -i 'DIR_GMP'/ST5DATE+TT.gmt -o 'DIR_GIF'/ST5+TT.gif'
'!rm 'DIR_GMP'/ST5DATE+TT.gmt'
'c'

***********  NEW PLOT  *********

* LINHAS DE CORRENTE EM 200 hPa

'enable print 'DIR_GMP'/ST2DATE+TT.gmt' 
'set strsiz 0.14'
'set string 1 c 5 '
'draw string 5.2  8.3   IPMET/CPTEC/INPE/MCT - Modelo Meso Eta 10km'
'draw string 5.2  8.1  Previs`6a`0o DATE+TTh, v`6b`0lida para DTLEUTC ('labw')'
'draw string 5.2  7.9  Linhas de Corrente e Magnitude do Vento (m/s) em 200 hPa'
'set grads off'
'set gxout stream'
'set cthick 3' 
'set lev 200'
'set clevs 1 10 20 30 40 50 60 70 80 90 100 110 120'
'set ccols 0 9 14 4 11 5 13 3 10 7 12 8 2 6'
'd uvel;vvel;mag(uvel,vvel)'
'run cbar.gs'
'print'
'disable print 'DIR_GMP'/ST2DATE+TT.gmt'
'!gxgif   -r   -i 'DIR_GMP'/ST2DATE+TT.gmt -o 'DIR_GIF'/ST2+TT.gif'
'!rm 'DIR_GMP'/ST2DATE+TT.gmt'
'c'

***********  NEW PLOT  *********
'run 'DIR_EXEC'/rgb2.gs'
* CONVERGENCIA DE UMIDADE EM 925  hPa

'enable print 'DIR_GMP'/DQ9DATE+TT.gmt' 
'set strsiz 0.14'
'set string 1 c 5 '
'draw string 5.2  8.3   IPMET/CPTEC/INPE/MCT - Modelo Meso Eta 10km'
'draw string 5.2  8.1  Previs`6a`0o DATE+TTh, v`6b`0lida para DTLEUTC ('labw')'
'draw string 5.2  7.9  Converg`6e`0ncia de Umidade em 925 hPa (10**-7/s)'
'set grads off'
'set gxout shaded'
'set lev 925'
'set clevs  -16 -14 -12 -10 -8 -6 -4 -2 0 2 4 6 8 10 12 14 16'
*'set clevs 0 3.0 5.0 7.0 10 15'
*'set ccols  0 41 42 43  44 45 46'
'd -hdivg(uvel*umes,vvel*umes)*1e7'
'run  cbar.gs'
'print'
'disable print 'DIR_GMP'/DQ9DATE+TT.gmt'
'!gxgif   -r   -i 'DIR_GMP'/DQ9DATE+TT.gmt -o 'DIR_GIF'/DQ9+TT.gif'
'!rm 'DIR_GMP'/DQ9DATE+TT.gmt'
'c'


***********  NEW PLOT  *********


* CONVERGENCIA DE UMIDADE EM 850  hPa

'enable print 'DIR_GMP'/DQ8DATE+TT.gmt'
'set strsiz 0.14'
'set string 1 c 5 '
'draw string 5.2  8.3   IPMET/CPTEC/INPE/MCT - Modelo Meso Eta 10km'
'draw string 5.2  8.1  Previs`6a`0o DATE+TTh, v`6b`0lida para DTLEUTC ('labw')'
'draw string 5.2  7.9  Converg`6e`0ncia de Umidade em 850 hPa (10**-7/s)'
'set grads off'
'set gxout shaded'
'set lev 850'
'set clevs  -16 -14 -12 -10 -8 -6 -4 -2 0 2 4 6 8 10 12 14 16'
*'set clevs 0 3.0 5.0 7.0 10 15'
*'set ccols  0 41 42 43  44 45 46'
'd -hdivg(uvel*umes,vvel*umes)*1e7'
'run  cbar.gs'
'print'
'disable print 'DIR_GMP'/DQ8DATE+TT.gmt'
'!gxgif   -r   -i 'DIR_GMP'/DQ8DATE+TT.gmt -o 'DIR_GIF'/DQ8+TT.gif'
'!rm 'DIR_GMP'/DQ8DATE+TT.gmt'
'c'

***********  NEW PLOT  *********
'run 'DIR_EXEC'/rgb.gs'
* OMEGA EM 850  hPa

'enable print 'DIR_GMP'/OM8DATE+TT.gmt'
'set strsiz 0.14'
'set string 1 c 5 '
'draw string 5.2  8.3   IPMET/CPTEC/INPE/MCT - Modelo Meso Eta 10km'
'draw string 5.2  8.1  Previs`6a`0o DATE+TTh, v`6b`0lida para DTLEUTC ('labw')'
'draw string 5.2  7.9 `6Q`0mega (Pa/s)  em 850 hPa'
'set grads off'
'set gxout shaded'
'set lev 850'
'set clevs -1.6  -1.4 -1.2  -1.0 -0.9 -0.8 -0.7 -0.6 -0.5 -0.4 -0.3 -0.2 -0.1 '
'set ccols 6 2 8 12 7 10 3 13 5 11 4 14 9 0'
*'set ccols    27   26  25   24    23   22   21  0 '
'd omeg'
'run  cbar.gs'
'set gxout contour'
'set cint 0.1'
'set cmin 0.0'
'd omeg'
'print'
'disable print 'DIR_GMP'/OM8DATE+TT.gmt'
'!gxgif   -r   -i 'DIR_GMP'/OM8DATE+TT.gmt -o 'DIR_GIF'/OM8+TT.gif'
'!rm 'DIR_GMP'/OM8DATE+TT.gmt'
'c'


***********  NEW PLOT  *********

* OMEGA EM  500  hPa

'enable print 'DIR_GMP'/OM5DATE+TT.gmt'
'set strsiz 0.14'
'set string 1 c 5 '
'draw string 5.2  8.3   IPMET/CPTEC/INPE/MCT - Modelo Meso Eta 10km'
'draw string 5.2  8.1  Previs`6a`0o DATE+TTh, v`6b`0lida para DTLEUTC ('labw')'
'draw string 5.2  7.9 `6Q`0mega (Pa/s)  em 500 hPa'
'set grads off'
'set gxout shaded'
'set lev 500'
*'set clevs  -1.2 -1.0 -0.8 -0.6 -0.4 -0.2  -0.1  '
*'set ccols    27   26  25   24    23   22   21     0 '
'set clevs -1.6  -1.4 -1.2  -1.0 -0.9 -0.8 -0.7 -0.6 -0.5 -0.4 -0.3 -0.2 -0.1 '
'set ccols 6  2 8  12 7 10 3 13 5 11 4 14 9  0'
'd omeg'
'run  cbar.gs'
'set gxout contour'
'set cint 0.1'
'set cmin 0.0'
'd omeg'
'print'
'disable print 'DIR_GMP'/OM5DATE+TT.gmt'
'!gxgif   -r   -i 'DIR_GMP'/OM5DATE+TT.gmt -o 'DIR_GIF'/OM5+TT.gif'
'!rm 'DIR_GMP'/OM5DATE+TT.gmt'
'c'


***********  NEW PLOT  *********

* OMEGA EM  300  hPa

'enable print 'DIR_GMP'/OM3DATE+TT.gmt'
'set strsiz 0.14'
'set string 1 c 5 '
'draw string 5.2  8.3   IPMET/CPTEC/INPE/MCT - Modelo Meso Eta 10km'
'draw string 5.2  8.1  Previs`6a`0o DATE+TTh, v`6b`0lida para DTLEUTC ('labw')'
'draw string 5.2  7.9 `6Q`0mega (Pa/s)  em 300 hPa'
'set grads off'
'set gxout shaded'
'set lev 300'
*'set clevs  -1.2 -1.0 -0.8 -0.6 -0.4 -0.2  -0.1  '
*'set ccols    27   26  25   24    23   22   21     0 '
'set clevs -1.6  -1.4 -1.2  -1.0 -0.9 -0.8 -0.7 -0.6 -0.5 -0.4 -0.3 -0.2 -0.1 '
'set ccols 6  2 8  12 7 10 3 13 5 11 4 14 9  0'
'd omeg'
'run  cbar.gs'
'set gxout contour'
'set cint 0.1'
'set cmin 0.0'
'd omeg'
'print'
'disable print 'DIR_GMP'/OM3DATE+TT.gmt'
'!gxgif   -r   -i 'DIR_GMP'/OM3DATE+TT.gmt -o 'DIR_GIF'/OM3+TT.gif'
'!rm 'DIR_GMP'/OM3DATE+TT.gmt'
'c'

***********  NEW PLOT  *********

* DIVERGENCIA EM 300 hPa

'enable print 'DIR_GMP'/HD3DATE+TT.gmt'
'set strsiz 0.14'
'set string 1 c 5 '
'draw string 5.2  8.3   IPMET/CPTEC/INPE/MCT - Modelo Meso Eta 10km'
'draw string 5.2  8.1  Previs`6a`0o DATE+TTh, v`6b`0lida para DTLEUTC ('labw')'
'draw string 5.2  7.9  Diverg`6e`0ncia em 300 hPa (10**-5/s)'
'set grads off'
'set gxout shaded'
'set lev 300'
'set clevs  -16 -14 -12 -10 -8 -6 -4 -2 0 2 4 6 8 10 12 14 16'
*'set clevs 0 0.5 1 1.5 2 2.5 3 3.5 4 4.5 5 5.5 6'
*'set ccols 0 9 14 4 11 5 13 3 10 7 12 8 2 6'
'd hdivg(uvel,vvel)*100000'
'run cbar.gs'
*'set gxout contour'
*'set cmax -1'
*'d hdivg(uvel,vvel)*100000'
'set gxout stream'
'set ccolor 2'
*'set cthick 5' 
'set strmden 2'
'd uvel;vvel'
'print'
'disable print 'DIR_GMP'/HD3DATE+TT.gmt'
'!gxgif   -r   -i 'DIR_GMP'/HD3DATE+TT.gmt -o 'DIR_GIF'/HD3+TT.gif'
'!rm 'DIR_GMP'/HD3DATE+TT.gmt'
'c'



***********  NEW PLOT  *********
* Autor:JMB

* DIVERGENCIA EM 200 hPa

'enable print 'DIR_GMP'/HD2DATE+TT.gmt'
'set strsiz 0.14'
'set string 1 c 5 '
'draw string 5.2  8.3   IPMET/CPTEC/INPE/MCT - Modelo Meso Eta 10km'
'draw string 5.2  8.1  Previs`6a`0o DATE+TTh, v`6b`0lida para DTLEUTC ('labw')'
'draw string 5.2  7.9  Diverg`6e`0ncia em 200 hPa (10**-5/s)'
'set grads off'
'set gxout shaded'
'set lev 200'
'set clevs  -16 -14 -12 -10 -8 -6 -4 -2 0 2 4 6 8 10 12 14 16'
'd hdivg(uvel,vvel)*100000'
'run cbar.gs'
'print'
'disable print 'DIR_GMP'/HD2DATE+TT.gmt'
'!gxgif   -r   -i 'DIR_GMP'/HD2DATE+TT.gmt -o 'DIR_GIF'/HD2+TT.gif'
'!rm 'DIR_GMP'/HD2DATE+TT.gmt'
'c'

***********  NEW PLOT  *********
* Autor:JMB

* DIVERGENCIA EM 850 hPa

'enable print 'DIR_GMP'/HD85DATE+TT.gmt'
'set strsiz 0.14'
'set string 1 c 5 '
'draw string 5.2  8.3   IPMET/CPTEC/INPE/MCT - Modelo Meso Eta 10km'
'draw string 5.2  8.1  Previs`6a`0o DATE+TTh, v`6b`0lida para DTLEUTC ('labw')'
'draw string 5.2  7.9  Diverg`6e`0ncia em 850 hPa (10**-5/s)'
'set grads off'
'set gxout shaded'
'set lev 850'
'set clevs  -16 -14 -12 -10 -8 -6 -4 -2 0 2 4 6 8 10 12 14 16'
'd hdivg(uvel,vvel)*100000'
'run cbar.gs'
'print'
'disable print 'DIR_GMP'/HD85DATE+TT.gmt'
'!gxgif   -r   -i 'DIR_GMP'/HD85DATE+TT.gmt -o 'DIR_GIF'/HD85+TT.gif'
'!rm 'DIR_GMP'/HD85DATE+TT.gmt'
'c'


***********  NEW PLOT  *********

* TEMPERATURA EM 925 hPa

'enable print 'DIR_GMP'/TMPDATE+TT.gmt'
'set strsiz 0.14'
'set string 1 c 5 '
'draw string 5.2  8.3   IPMET/CPTEC/INPE/MCT - Modelo Meso Eta 10km'
'draw string 5.2  8.1  Previs`6a`0o DATE+TTh, v`6b`0lida para DTLEUTC ('labw')'
'draw string 5.2  7.9 Temperatura (C) em 2 metros'
'set grads off'
'set gxout shaded'
'set lev 925'
'd tp2m-273.15'
'run  cbar.gs'
*'set clevs  20 22 24 26 28 30 32 34 36'
*'set ccols  4 11 5 3 10 7 12 8 2 6'
'set gxout contour'
'd tp2m-273.15'
'print'
'disable print 'DIR_GMP'/TMPDATE+TT.gmt'
'!gxgif   -r   -i 'DIR_GMP'/TMPDATE+TT.gmt -o 'DIR_GIF'/TMP+TT.gif'
'!rm 'DIR_GMP'/TMPDATE+TT.gmt'
'c'

**************NEW PLOT *********

* AUTOR= JMB

'enable print 'DIR_GMP'/fzhtDATE+TT.gmt'
'set strsiz 0.14'
'set string 1 c 5 '
'draw string 5.2  8.3   IPMET/CPTEC/INPE/MCT - Modelo Meso Eta 10km'
'draw string 5.2  8.1  Previs`6a`0o DATE+TTh, v`6b`0lida para DTLEUTC ('labw')'
'draw string 5.2  7.9 Altura do n`6i`0vel de congelamento (m)'
'set grads off'
'set gxout contour'
'd fzht'
'print'
'disable print 'DIR_GMP'/fzhtDATE+TT.gmt'
'!gxgif   -r   -i 'DIR_GMP'/fzhtDATE+TT.gmt -o 'DIR_GIF'/fzht+TT.gif'
'!rm 'DIR_GMP'/fzhtDATE+TT.gmt'
'c'


***********  NEW PLOT  *********

* INDICE K

'enable print 'DIR_GMP'/KIDDATE+TT.gmt'
'set strsiz 0.14'
'set string 1 c 5 '
'draw string 5.2  8.3   IPMET/CPTEC/INPE/MCT - Modelo Meso Eta 10km'
'draw string 5.2  8.1  Previs`6a`0o DATE+TTh, v`6b`0lida para DTLEUTC ('labw')'
'draw string 5.2  7.9 `6I`0ndice K'
'set grads off'
'define tc8=temp(lev=850)-273.15'
'define tc7=temp(lev=700)-273.15'
'define tc5=temp(lev=500)-273.15'
'define es8=6.107*exp(17.6153*tc8/(242.567+tc8))'
'define es7=6.107*exp(17.6153*tc7/(242.567+tc7))'
'define es5=6.107*exp(17.6153*tc5/(242.567+tc5))'
'define rs8=es8*622.0/(850-es8)'
'define rs7=es7*622.0/(700-es7)'
'define rs5=es5*622.0/(500-es5)'
'define r8=(umrl(lev=850))/100*rs8'
'define r7=(umrl(lev=700))/100*rs7'
'define r5=(umrl(lev=500))/100*rs5'
'define td8=242.567*log((r8*850)/(r8+622.0)/6.107)/(17.6153-log((r8*850)/(r8+622.0)/6.107))'
'define td7=242.567*log((r7*700)/(r7+622.0)/6.107)/(17.6153-log((r7*700)/(r7+622.0)/6.107))'
'define td5=242.567*log((r5*500)/(r5+622.0)/6.107)/(17.6153-log((r5*850)/(r5+622.0)/6.107))'
'define k=tc8-tc5+td8-tc7+td7'
'set cmin 30'
'set cint 2' 
'set cthick 3'
'set gxout shaded'
'd k'
'run  cbar.gs'
'set gxout contour'
'd k'
'print'
'disable print 'DIR_GMP'/KIDDATE+TT.gmt'
'!gxgif  -r   -i 'DIR_GMP'/KIDDATE+TT.gmt -o 'DIR_GIF'/KID+TT.gif'
'!rm 'DIR_GMP'/KIDDATE+TT.gmt'
'c'

***********  NEW PLOT  *********
* indice K e total
* autor= JMB
'enable print 'DIR_GMP'/KIDTDATE+TT.gmt'
'set strsiz 0.14'
'set string 1 c 5 '
'draw string 5.2  8.3   IPMET/CPTEC/INPE/MCT - Modelo Meso Eta 10km'
'draw string 5.2  8.1  Previs`6a`0o DATE+TTh, v`6b`0lida para DTLEUTC ('labw')'
'draw string 5.2  7.9 `6I`0ndice K e Total(linhas)'
'set grads off'
'define tc8=temp(lev=850)-273.15'
'define tc7=temp(lev=700)-273.15'
'define tc5=temp(lev=500)-273.15'
'define es8=6.107*exp(17.6153*tc8/(242.567+tc8))'
'define es7=6.107*exp(17.6153*tc7/(242.567+tc7))'
'define es5=6.107*exp(17.6153*tc5/(242.567+tc5))'
'define rs8=es8*622.0/(850-es8)'
'define rs7=es7*622.0/(700-es7)'
'define rs5=es5*622.0/(500-es5)'
'define r8=(umrl(lev=850))/100*rs8'
'define r7=(umrl(lev=700))/100*rs7'
'define r5=(umrl(lev=500))/100*rs5'
'define td8=242.567*log((r8*850)/(r8+622.0)/6.107)/(17.6153-log((r8*850)/(r8+622.0)/6.107))'
'define td7=242.567*log((r7*700)/(r7+622.0)/6.107)/(17.6153-log((r7*700)/(r7+622.0)/6.107))'
'define td5=242.567*log((r5*500)/(r5+622.0)/6.107)/(17.6153-log((r5*850)/(r5+622.0)/6.107))'
'define k=tc8-tc5+td8-tc7+td7'
'set cmin 20'
'set cint 2'
'set cthick 3'
'set gxout shaded'
'd k'
'run  cbar.gs'
'set gxout contour'
'define kt=tc8+td8-(2*tc5)'
'd kt'
'print'
'disable print 'DIR_GMP'/KIDTDATE+TT.gmt'
'!gxgif  -r   -i 'DIR_GMP'/KIDTDATE+TT.gmt -o 'DIR_GIF'/KIDT+TT.gif'
'!rm 'DIR_GMP'/KIDTDATE+TT.gmt'
'c'


***********  NEW PLOT  ********* 

* INDICE LI

'enable print 'DIR_GMP'/LIDDATE+TT.gmt'
'set strsiz 0.14'
'set string 1 c 5 '
'draw string 5.2  8.3   IPMET/CPTEC/INPE/MCT - Modelo Meso Eta 10km'
'draw string 5.2  8.1  Previs`6a`0o DATE+TTh, v`6b`0lida para DTLEUTC ('labw')'
'draw string 5.2  7.9 `6I`0ndice de Levantamento'
'set grads off'
'set cint 2'
'set cthick 3'
'd bli'
'run  cbar.gs'
'print'
'disable print 'DIR_GMP'/LIDDATE+TT.gmt'
'!gxgif   -r   -i 'DIR_GMP'/LIDDATE+TT.gmt -o 'DIR_GIF'/LID+TT.gif'
'!rm 'DIR_GMP'/LIDDATE+TT.gmt'
'clear'

***********  NEW PLOT  *********
 
* FRACAO DE COBERTURA DE NUVENS
 
'enable print 'DIR_GMP'/CLDDATE+TT.gmt'
'set strsiz 0.14'
'set string 1 c 5 '
'draw string 5.2  8.3   IPMET/CPTEC/INPE/MCT - Modelo Meso Eta 10km'
'draw string 5.2  8.1  Previs`6a`0o DATE+TTh, v`6b`0lida para DTLEUTC ('labw')'
'draw string 5.2  7.9 Fra`6ca`0o de Cobertura de Nuvens'
'set grads off'
'set gxout shaded'
'set clevs  0.2 0.4 0.6 0.8'
'set ccols 0 41 43 45 47'
'd cbnt'
'run cbar.gs'
'print'
'disable print 'DIR_GMP'/CLDDATE+TT.gmt'
'!gxgif   -r  -i 'DIR_GMP'/CLDDATE+TT.gmt -o 'DIR_GIF'/CLD+TT.gif'
'!rm 'DIR_GMP'/CLDDATE+TT.gmt'
'c'

***********  NEW PLOT  *********

* RADIACAO DE ONDA LONGA

'enable print 'DIR_GMP'/ROLDATE+TT.gmt' 
'set strsiz 0.14'
'set string 1 c 5 '
'draw string 5.2  8.3   IPMET/CPTEC/INPE/MCT - Modelo Meso Eta 10km'
'draw string 5.2  8.1  Previs`6a`0o DATE+TTh, v`6b`0lida para DTLEUTC ('labw')'
'draw string 5.2  7.9 Radia`6ca`0o de Onda Longa (W/m*2)'
'set grads off'
'set gxout shaded'
'set clevs 160 180 200 220 240 260'
'set ccols 80 81 82 83 84 85 0' 
'd role'
'run cbar.gs'
'print'
'disable print 'DIR_GMP'/ROLDATE+TT.gmt'
'!gxgif   -r   -i 'DIR_GMP'/ROLDATE+TT.gmt -o 'DIR_GIF'/ROL+TT.gif'
'!rm 'DIR_GMP'/ROLDATE+TT.gmt'
'c'

***********  NEW PLOT  *********
'run 'DIR_EXEC'/rgb3.gs'

* PRECIPITACAO ACUMULADA EM 3 HORAS 

'enable print 'DIR_GMP'/PRCDATE+TT.gmt' 
'set strsiz 0.14'
'set string 1 c 5 '
'draw string 5.2  8.3   IPMET/CPTEC/INPE/MCT - Modelo Meso Eta 10km'
'draw string 5.2  8.1  Previs`6a`0o DATE+TTh, v`6b`0lida para DTLEUTC ('labw')'
'draw string 5.2  7.9 Precipita`6ca`0o Acum. em 'int' h (mm), PNM (hPa), Vento em 10 m (kt)'
'set grads off'
'set gxout shaded'
*'set cmin 1'
*'set ccolor rainbow'
'set clevs  1 2 4 6 8 10 12 14 16 18 20 25 30 40 50 70'
'set ccols  0 21 22 23 24 25 26 27 28 29 30 31 32 33 34 35 36'
'd sum(prec*1000,t='ti-int',t='ti')'
'run  cbar.gs'
'set lev 1000'
'set gxout barb'
'd 1.94384*skip(u10m,5);1.94384*v10m'
'set gxout contour'
'set cint 1'
'set cthick 5'
'set ccolor 4'
'd pslm'
'print'
'disable print 'DIR_GMP'/PRCDATE+TT.gmt'
'!gxgif   -r   -i 'DIR_GMP'/PRCDATE+TT.gmt -o 'DIR_GIF'/PRC+TT.gif'
'!rm 'DIR_GMP'/PRCDATE+TT.gmt'
'c'

***********  NEW PLOT  *********
'run 'DIR_EXEC'/rgb.gs'

* TEMPERATURA DO PONTO DE ORVALHO EM 925 hPa

'enable print 'DIR_GMP'/TD9DATE+TT.gmt'
'set strsiz 0.14'
'set string 1 c 5 '
'draw string 5.2  8.3   IPMET/CPTEC/INPE/MCT - Modelo Meso Eta 10km'
'draw string 5.2  8.1  Previs`6a`0o DATE+TTh, v`6b`0lida para DTLEUTC ('labw')'
'draw string 5.2  7.9  Td(linhas) e Depress`6a`0o(sombreado) em 925 hPa (C)'
'set grads off'
'define tc9=temp(lev=925)-273.15'
'define es9=6.107*exp(17.6153*tc9/(242.567+tc9))'
'define rs9=es9*622.0/(925-es9)'
'define r9=(umrl(lev=925))/100*rs9'
'define td9=242.567*log((r9*925)/(r9+622.0)/6.107)/(17.6153-log((r9*925)/(r9+622.0)/6.107))'
'set gxout shaded'
'set clevs  2 4 6'
'set ccols 49 48 47 0'
'd ((temp-273.15)-td9)'
'set gxout contour'
'set cint 3'
'set ccolor rainbow'
'set cthick 3'
'd td9'
'run cbar.gs'
'print'
'disable print 'DIR_GMP'/TD9DATE+TT.gmt'
'!gxgif   -r   -i 'DIR_GMP'/TD9DATE+TT.gmt -o 'DIR_GIF'/TD9+TT.gif'
'!rm 'DIR_GMP'/TD9DATE+TT.gmt'
'c'

************** NEW PLOT ***************

* Autor= JMB

** UMIDADE RELATIVA A 2 METROS

'enable print 'DIR_GMP'/ur2mDATE+TT.gmt' 
'set strsiz 0.14'
'set string 1 c 5 '
'draw string 5.2  8.3   IPMET/CPTEC/INPE/MCT - Modelo Meso Eta 10km'
'draw string 5.2  8.1  Previs`6a`0o DATE+TTh, v`6b`0lida para DTLEUTC ('labw')'
'draw string 5.2  7.9  Umidade Relativa ( % ) a 02 metros '
'set grads off'
'set gxout shaded'
'tp=tp2m-273.16'
'tr=7.5*tp/(tp+237.3)'
'tres=6.11*pow(10,tr)'
'dp=dp2m-273.16'
'tdr=7.5*dp/(dp+237.3)'
'tdres=6.11*pow(10,tdr)'
'ur2m=tdres/tres'
'd ur2m*100'
'run cbar.gs'
'print'
'disable print 'DIR_GMP'/ur2mDATE+TT.gmt'
'!gxgif   -r  -i 'DIR_GMP'/ur2mDATE+TT.gmt -o 'DIR_GIF'/ur2m+TT.gif'
'!rm 'DIR_GMP'/ur2mDATE+TT.gmt'
'c'
************** NEW PLOT ***************

* Autor= JMB 23/09/08

** INDICE DE ESTABILIDADE DE NEVOEIRO

'enable print 'DIR_GMP'/ienDATE+TT.gmt'
'set strsiz 0.14'
'set string 1 c 5 '
'draw string 5.2  8.3   IPMET/CPTEC/INPE/MCT - Modelo Meso Eta 10km'
'draw string 5.2  8.1  Previs`6a`0o DATE+TTh, v`6b`0lida para DTLEUTC ('labw')'
'draw string 5.2  7.9  `6I`0ndice de Estabilidade de Nevoeiro'
'set grads off'
'set gxout contour'
't2m=tp2m-273.16'
'td2m=dp2m-273.16'
'set lev 850'
't850=temp-273.16'
'u850=mag(uvel,vvel)*1.92'
'ien=4*t2m-2*(t850+td2m)+u850'
'd ien'
'run cbar.gs'
'print'
'disable print 'DIR_GMP'/ienDATE+TT.gmt'
'!gxgif   -r  -i 'DIR_GMP'/ienDATE+TT.gmt -o 'DIR_GIF'/ien+TT.gif'
'!rm 'DIR_GMP'/ienDATE+TT.gmt'
'c'

************** NEW PLOT ***************

* Autor= JMB

* VORTICIDADE EM 200 hPa

'enable print 'DIR_GMP'/VT2DATE+TT.gmt'
'set strsiz 0.14'
'set string 1 c 5 '
'draw string 5.2  8.3   IPMET/CPTEC/INPE/MCT -  MODELO Meso Eta 10km'
'draw string 5.2  8.1  Previs`6a`0o DATE+TTh, v`6b`0lida para DTLEUTC ('labw')'
'draw string 5.2  7.9  Vorticidade em 200 hPa (10**-5/s)'
'set grads off'
'set gxout shaded'
'set lev 200'
*'set clevs  -16 -14 -12 -10 -8 -6 -4 -2 0 2 4 6 8 10 12 14 16'
'd hcurl(uvel,vvel)*100000'
'run cbar.gs'
'set gxout stream'
'set ccolor 2'
*'set cthick 5'
'set strmden 2'
'd uvel;vvel'
'print'
'disable print 'DIR_GMP'/VT2DATE+TT.gmt'
'!gxgif   -r   -i 'DIR_GMP'/VT2DATE+TT.gmt -o 'DIR_GIF'/VT2+TT.gif'
'!rm 'DIR_GMP'/VT2DATE+TT.gmt'
'c'

************** NEW PLOT ***************

* Autor= JMB

* VORTICIDADE EM 300 hPa

'enable print 'DIR_GMP'/VT3DATE+TT.gmt'
'set strsiz 0.14'
'set string 1 c 5 '
'draw string 5.2  8.3   IPMET/CPTEC/INPE/MCT -  MODELO Meso Eta 10km'
'draw string 5.2  8.1  Previs`6a`0o DATE+TTh, v`6b`0lida para DTLEUTC ('labw')'
'draw string 5.2  7.9  Vorticidade em 300 hPa (10**-5/s)'
'set grads off'
'set gxout shaded'
'set lev 300'
*'set clevs  -16 -14 -12 -10 -8 -6 -4 -2 0 2 4 6 8 10 12 14 16'
'd hcurl(uvel,vvel)*100000'
'run cbar.gs'
'set gxout stream'
'set ccolor 2'
*'set cthick 5'
'set strmden 2'
'd uvel;vvel'
'print'
'disable print 'DIR_GMP'/VT3DATE+TT.gmt'
'!gxgif   -r   -i 'DIR_GMP'/VT3DATE+TT.gmt -o 'DIR_GIF'/VT3+TT.gif'
'!rm 'DIR_GMP'/VT3DATE+TT.gmt'
'c'

************** NEW PLOT ***************

* Autor= JMB

* VORTICIDADE EM 500 hPa

'enable print 'DIR_GMP'/VT5DATE+TT.gmt'
'set strsiz 0.14'
'set string 1 c 5 '
'draw string 5.2  8.3   IPMET/CPTEC/INPE/MCT -  MODELO Meso Eta 10km'
'draw string 5.2  8.1  Previs`6a`0o DATE+TTh, v`6b`0lida para DTLEUTC ('labw')'
'draw string 5.2  7.9  Vorticidade em 500 hPa (10**-5/s)'
'set grads off'
'set gxout shaded'
'set lev 500'
*'set clevs  -16 -14 -12 -10 -8 -6 -4 -2 0 2 4 6 8 10 12 14 16'
'd hcurl(uvel,vvel)*100000'
'run cbar.gs'
'set gxout stream'
'set ccolor 2'
*'set cthick 5'
'set strmden 2'
'd uvel;vvel'
'print'
'disable print 'DIR_GMP'/VT5DATE+TT.gmt'
'!gxgif   -r   -i 'DIR_GMP'/VT5DATE+TT.gmt -o 'DIR_GIF'/VT5+TT.gif'
'!rm 'DIR_GMP'/VT5DATE+TT.gmt'
'c'

************** NEW PLOT ***************

* Autor= JMB

* VORTICIDADE EM 850 hPa

'enable print 'DIR_GMP'/VT85DATE+TT.gmt'
'set strsiz 0.14'
'set string 1 c 5 '
'draw string 5.2  8.3   IPMET/CPTEC/INPE/MCT -  MODELO Meso Eta 10km'
'draw string 5.2  8.1  Previs`6a`0o DATE+TTh, v`6b`0lida para DTLEUTC ('labw')'
'draw string 5.2  7.9  Vorticidade em 850 hPa (10**-5/s)'
'set grads off'
'set gxout shaded'
'set lev 850'
*'set clevs  -16 -14 -12 -10 -8 -6 -4 -2 0 2 4 6 8 10 12 14 16'
'd hcurl(uvel,vvel)*100000'
'run cbar.gs'
'set gxout stream'
'set ccolor 2'
*'set cthick 5'
'set strmden 2'
'd uvel;vvel'
'print'
'disable print 'DIR_GMP'/VT85DATE+TT.gmt'
'!gxgif   -r   -i 'DIR_GMP'/VT85DATE+TT.gmt -o 'DIR_GIF'/VT85+TT.gif'
'!rm 'DIR_GMP'/VT85DATE+TT.gmt'
'c'

* Este programa abaixo gera arquivos ascii do perfil vertical de Bauru, a cada 3 horas de previsao do modelo.
* Autor: JMB 01/2012.

'set lat -22.35'
'set lon -49.02'
fmt1='%4.1f'
fmt2='%1.10f'
fmt3='%5.1f'
fmt4='%3.2f'
fmt5='%3.2f'

w=write(DIR_GIF'/'DATE'+'TT'_BRU-IPMET.txt','pressão(hPa) temp(C)       umes(kg/kg)           zgeo(gpm)      uvel(m/s)   vvel(m/s)')
s="          "
i=1000
while (i>=475)
'set lev 'i
'd temp-273.16'
rec=sublin(result,1)
auxrec=subwrd(rec,4)
auxp=substr(auxrec,1,5)
'd zgeo'
rec1=sublin(result,1)
auxrec1=subwrd(rec1,4)
auxz=substr(auxrec1,1,5)
'd umes'
rec2=sublin(result,1)
auxrec2=subwrd(rec2,4)
auxu=substr(auxrec2,1,11)
'd uvel'
rec3=sublin(result,1)
auxrec3=subwrd(rec3,4)
auxuvel=substr(auxrec3,1,5)
'd vvel'
rec4=sublin(result,1)
auxrec4=subwrd(rec4,4)
auxvvel=substr(auxrec4,1,5)

auxp=math_format(fmt1,auxp)
auxu=math_format(fmt2,auxu)
auxz=math_format(fmt3,auxz)
auxuvel=math_format(fmt4,auxuvel)
auxvvel=math_format(fmt5,auxvvel)

w=write(DIR_GIF'/'DATE'+'TT'_BRU-IPMET.txt',i''s''auxp''s''auxu''s''auxz''s''auxuvel''s''auxvvel,append)
i=i - 25
endwhile
i=450
while (i>=100)
'set lev 'i
'd temp-273.16'
rec=sublin(result,1)
auxrec=subwrd(rec,4)
auxp=substr(auxrec,1,5)
'd zgeo'
rec1=sublin(result,1)
auxrec1=subwrd(rec1,4)
auxz=substr(auxrec1,1,5)
'd umes'
rec2=sublin(result,1)
auxrec2=subwrd(rec2,4)
auxu=substr(auxrec2,1,11)
'd uvel'
rec3=sublin(result,1)
auxrec3=subwrd(rec3,4)
auxuvel=substr(auxrec3,1,5)
'd vvel'
rec4=sublin(result,1)
auxrec4=subwrd(rec4,4)
auxvvel=substr(auxrec4,1,5)

auxp=math_format(fmt1,auxp)
auxu=math_format(fmt2,auxu)
auxz=math_format(fmt3,auxz)
auxuvel=math_format(fmt4,auxuvel)
auxvvel=math_format(fmt5,auxvvel)

w=write(DIR_GIF'/'DATE'+'TT'_BRU-IPMET.txt',i''s''auxp''s''auxu''s''auxz''s''auxuvel''s''auxvvel,append)
i=i - 50
endwhile
*'close 1'
c=close(DIR_GIF'/'DATE'+'TT'_BRU-IPMET.txt')
'quit'
return

'quit'
