#! /bin/ksh -x

DATE=$1 


DIR_WRK=/trab_coroca/meta/worketa_all/posfig
DIR_GRBCTL=/trab_coroca/meta/worketa_all/data/grib
#DIR_GRBCTL=/rede/comum01/sst/E05551
DIR_EXEC=${DIR_WRK}/scripts
DIR_GMP=${DIR_WRK}/gmp
DIR_GIF=${DIR_WRK}/gif



cat <<EOF> pslm.gs
'reinit'
'c'
'open ${DIR_GRBCTL}/ll40ganl${DATE}.ctl'
date.1=`/home/metop/bin/caldate.3.0 ${DATE} + 0h 'yyyymmddhh'`
date.2=`/home/metop/bin/caldate.3.0 ${DATE} + 24h 'yyyymmddhh'`
date.3=`/home/metop/bin/caldate.3.0 ${DATE} + 48h 'yyyymmddhh'`
date.4=`/home/metop/bin/caldate.3.0 ${DATE} + 72h 'yyyymmddhh'`

DTLEUTC.1=`/home/metop/bin/caldate.3.0 ${DATE} + 0h 'hhZddmmmyyyy'`
DTLEUTC.2=`/home/metop/bin/caldate.3.0 ${DATE} + 24h 'hhZddmmmyyyy'`
DTLEUTC.3=`/home/metop/bin/caldate.3.0 ${DATE} + 48h 'hhZddmmmyyyy'`
DTLEUTC.4=`/home/metop/bin/caldate.3.0 ${DATE} + 72h 'hhZddmmmyyyy'`

i=1

 while (i<5)
'reinit'
'c' 
'set t 1'
'open ${DIR_GRBCTL}/ll40ganl'date.i'.ctl'
'set ccolor 1'
'set mpdset brmap_hires'
'run ${DIR_EXEC}/rgb.gs'
'set rgb 21    0   209    234'
'set rgb 22    0   176    210'
'set rgb 23    0   170    181'
'set rgb 24    0   158    161'
'set rgb 25    0   130    156'
'set rgb 26    0   117    146'
'set rgb 27    0    99    139'
'set rgb 28    0    88    130'
'set rgb 29    0    53    106'
'set rgb 30    0    33     93'
'set rgb 31    0     8     89'
'set rgb 32    0     0     38'

********* + HP precip  **********
'set gxout contour'
*'set cmin 5'
'set cint 1'
'set ccolor 1'
'set lat -35 -15'
'set lon 300 330'

'enable print pslm'date.i'.gmt'
*'set clevs 0 1 3 5 10 15 20 25 30 40 50 60 80 100'
*'set ccols 9 14 4 11 5 13 3 10 7 12 8 2 6' 
'set grads off' 
'd pslm'
*'run cbar.gs'
'set strsiz 0.08'
'set string 1 c 5'
*'draw string 0.8 5  CPTEC/INPE/MCT '
*'draw string 0.7 4.5  Eta Operacional'
'draw title  Pressao ao Nivel Medio do mar (hPa)'
'set strsiz 0.18'
'draw string 5.4 0.3 Analise, valida para 'DTLEUTC.i
'print'
'disable print pslm'date.i'.gmt'
'!gxgif -r -x 470 -y 360 -i pslm'date.i'.gmt -o ${DIR_GIF}/pslm'date.i'.gif'
'!rm pslm'date.i'.gmt'
*'q pos'
'c'
  i=i+1

 endwhile

'quit'

EOF

/home/metop/GrADS-1.7Beta6/bin/grads -lc "run pslm.gs"

exit
