DIR_Eta='/home/modelo/worketa/eta/101X141X38_2proc/posfig'
DIR_EXEC=DIR_Eta'/scripts'
DIR_GMP=DIR_Eta'/gmp'
DIR_GIF=DIR_Eta'/hstgif'

'open /home/modelo/worketa/eta/dados/101X141X38_2proc/grbctl/10km/2012081600/eta_modelo10km2012081600.ctl'
'open /home/modelo/worketa/eta/dados/101X141X38_2proc/indsev/10km/2012081600/Indices2012081600.ctl' 

'set t 1 last'
'set lev  1000 100'
'set lev 1000'

cid.1='Bauru_IPMet';latx.1='-22.35';lonx.1='-49.03';alt.1='620'
cid.2='Sao_Paulo';latx.2='-23.53';lonx.2='-46.62';alt.2='800'
cid.3='Presidente_Prudente';latx.3='-22.12';lonx.3='-51.38';alt.3='460'
cid.4='Ourinhos';latx.4='-22.97';lonx.4='-49.87';alt.4='492'
cid.5='Marilia';latx.5='-22.22';lonx.5='-49.95';alt.5='671'
cid.6='Sao_Jose_do_Rio_Preto';latx.6='-20.81';lonx.6='-49.38';alt.6='500'
cid.7='Ribeirao_Preto';latx.7='-21.17';lonx.7='-47.81';alt.7='531'
cid.8='Araraquara';latx.8='-21.79';lonx.8='-48.18';alt.8='660'
cid.9='Registro';latx.9='-24.48';lonx.9='-47.83';alt.9='40'
cid.10='Campos_do_Jordao';latx.10='-22.72';lonx.10='-45.57';alt.10='1620'
cid.11='Ubatuba';latx.11='-23.43';lonx.11='-45.06';alt.11='2'
cid.12='Rio_Claro';latx.12='-22.40';lonx.12='-47.52';alt.12='620'
cid.13='Campinas';latx.13='-22.88';lonx.13='-47.07';alt.13='680'
cid.14='Ilha_Solteira';latx.14='-20.42';lonx.14='-51.34';alt.14='375'
cid.15='Ibitinga';latx.15='-21.75';lonx.15='-48.81';alt.15='480'
cid.16='Praia_Grande';latx.16='-24.00';lonx.16='-46.41';alt.16='5'
cid.17='Santos';latx.17='-23.95';lonx.17='-46.33';alt.17='10'
cid.18='Brotas';latx.18='-22.16';lonx.18='-48.12';alt.18='660'
cid.19='Lins';latx.19='-21.67';lonx.19='-49.75';alt.19='484'
cid.20='Bauru_SJTC';latx.20='-22.16';lonx.20='-49.07';alt.20='594'
cid.21='Gaviao_Peixoto';latx.21='-21.76';lonx.21='-49.40';alt.21='606'
cid.22='Barretos';latx.22='-20.55';lonx.22='-48.57';alt.22='540'
cid.23='Franca';latx.23='-20.53';lonx.23='-47.40';alt.23='1000'
cid.24='Sao_Carlos';latx.24='-22.02';lonx.24='-47.89';alt.24='830'
cid.25='Sao_Jose_dos_Campos';latx.25='-23.19';lonx.25='-45.88';alt.25='594'

i=1
while (i<26)
'reset'
'set t 1 last'
'set lat 'latx.i
'set lon 'lonx.i

'set parea 0.5 8 2.1 3.3'
'set lev 1000'
'set gxout stat'
'd agpl'

rec=sublin(result,8)
yminx=subwrd(rec,4)
ymaxx=subwrd(rec,5)
say yminx'  'ymaxx
'set gxout contour'
'set cmark 0'
'set ylint 2'
'set ylab on'
*'set xlabs  | | | | | '
'set xlopts 0'
'set vrange  'yminx-1'   'ymaxx+1
'set ccolor 6'
'set grads off'
'd agpl'
'set parea off'

'set parea 0.5 8 3.7 4.9'
'set lev 1000'
'set gxout stat'
'd cape.2'
rec=sublin(result,8)
yminx=subwrd(rec,4)
ymaxx=subwrd(rec,5)

'set gxout contour'
'set cmark 0'
'set ylint 300'
'set ylab on'
'set vrange  'yminx-10'  'ymaxx+10
'set grads off'
'set ccolor 3'
'd cape.2'
'set parea off'

'set parea 0.5 8 5.3 6.5'
'set lev 1000'
'set gxout stat'
'd cin.2'
rec=sublin(result,8)
yminx=subwrd(rec,4)
ymaxx=subwrd(rec,5)
'set gxout contour'
'set cmark 0'
'set ylint -50'
'set ylab %.0f'
'set vrange  'yminx'  'ymaxx
'set grads off'
'd cin.2'
'set parea off'

'set parea 0.5 8 6.9 8.1'
'define tc8=temp(lev=850)-273.15'
'define tc7=temp(lev=700)-273.15'
'define tc5=temp(lev=500)-273.15'
'define es8=6.107*exp(17.6153*tc8/(242.567+tc8))'
'define es7=6.107*exp(17.6153*tc7/(242.567+tc7))'
'define es5=6.107*exp(17.6153*tc5/(242.567+tc5))'
'define rs8=es8*622.0/(850-es8)'
'define rs7=es7*622.0/(700-es7)'
'define rs5=es5*622.0/(500-es5)'
'define r8=(umrl(lev=850))/100*rs8'
'define r7=(umrl(lev=700))/100*rs7'
'define r5=(umrl(lev=500))/100*rs5'
'define td8=242.567*log((r8*850)/(r8+622.0)/6.107)/(17.6153-log((r8*850)/(r8+622.0)/6.107))'
'define td7=242.567*log((r7*700)/(r7+622.0)/6.107)/(17.6153-log((r7*700)/(r7+622.0)/6.107))'
'define td5=242.567*log((r5*500)/(r5+622.0)/6.107)/(17.6153-log((r5*850)/(r5+622.0)/6.107))'
'define k=tc8-tc5+td8-tc7+td7'
'set gxout stat'
'd k'
rec=sublin(result,8)
yminx=subwrd(rec,4)
ymaxx=subwrd(rec,5)
'set gxout contour'
'set cmark 0'
'set ylab on'
'set ylint 2'
'set vrange  'yminx-1'  'ymaxx+1
'set grads off'
'set ccolor 4'
'd k'
'set parea off'


'set parea 0.5 8 8.5 9.8'
'set lev 1000'
'set gxout stat'
'd li.2'
rec=sublin(result,8)
yminx=subwrd(rec,4)
ymaxx=subwrd(rec,5)

'set gxout contour'
'set ylint 1'
'set vrange 'yminx-1'  'ymaxx+1
'set grads off'
'set cmark 0'
'set ccolor 6'
'd li.2'

'set parea off'

'set parea 0.5 8 0.5 1.7'
'set lev 1000'

'set gxout bar'
'set baropts outline' 
'set ylint 30'
'set vrange 0 110'
'set cmark 0'
'set grads off'
'set xlopts 1'
'set xlab on'
'set ccolor 3'
'set bargap 90'
'd hinv'
'set grads off'
'set ylab off'
'set ccolor 2'
'set bargap 60'
'd mdnv'
'set grads off'
'set ylab on'
'set ccolor 4'
'set bargap 20'
'd lwnv'
'set parea off'

* Titles
'set strsiz 0.13'
'draw string 1 3.4 `6B`0gua Precipit`6b`0vel (kg/m^2)'
'draw string 1 5 Energia Pot. Convec. Dispon`6i`0vel (CAPE) (J/kg)'
'draw string 1 6.6 Inibi`6ca`0o Convectiva (CINE) (J/kg)'
'draw string 1 9.9 `6I`0ndice de Inst. por Levantamento (Lifted)'
'draw string 1 8.2 `6I`0ndice K'
'set strsiz 0.15'
'draw string 1 1.8 Cobertura de Nuvens (%)' 
'set line 4 1 2'
'draw rec 4.4 1.8 4.5 2' 
'draw string 4.6 1.8 Baixa ' 
'set line 2 1 2'
'draw rec 5.4 1.8 5.5 2' 
'draw string 5.6 1.8 M`6g`0dia ' 
'set line 3 1 2'
'draw rec  6.4 1.8 6.5 2' 
'draw string 6.6 1.8 Alta' 

'set t 1'
'd topo'
topX=subwrd(result,4)
'set string 4 c'
'set strsiz 0.17'
'draw string 4.25 10.8 IPMet/MCT/INPE/CPTEC - Modelo Meso Eta (10x10km)'
'set string 8 c'
'set strsiz 0.13'
'set t 1'
'q time'
rec=subwrd(result,3)
date=substr(rec,4,12)
hh=substr(rec,1,3)
'draw string 4.25 10.5 Data: 'date', 'hh' 'cid.i' (lat='latx.i'; lon='lonx.i')'
'draw string 4.25 10.25 Topografia - Modelo='topX'm  Real=' alt.i'm'
'enable print 'DIR_GMP'/meteogr.gmt'
'print'
'disable print'
'!gxgif   -r -x 520 -y 670 -i 'DIR_GMP'/meteogr.gmt -o 'DIR_GIF'/Met1_'cid.i'.gif'
i=i+1
endwhile
'quit'
