! sub  PROGRAM DOCUMENTATION BLOCK
!                .      .    .                                       .
! sub  PROGRAM:  gridst   READ GLOBAL Grid SST
!                            
!
! ABSTRACT: This program read the SST with 0.25 degree in a grid format
!		from ftp ftp://eclipse.ncdc.noaa.gov/pub/OI-daily-v2/IEEE/
!		either AVHRR or AVHRR-AMSR products can be readen 
!
!		Actually, we find four variables in the file, as listened bellow:
!		sst   - sea surface temperature array (deg C)
!		anom  - sea surface temperature anomalies array (deg C)
!		err   - standard deviation error of sea surface temperature array (deg C)
!		ice   - sea ice concentration (percentage)
!	
!		As much as the date of analysis:
! 		iyr   - year of analysis
!		imo   - month of analysis
!		ida   - day of analysis
!
!		Each file contains 4 records with integer*4 year, month, day, 
!		followed by a gridded integer*2 array. The first array is SST. 
!		The second array is the SST anomaly with respect to a 1971-2000 
!		base period. The third array is the sea ice concentration. 
!		The fourth array is the standard deviation of the analysis error 
!		which includes sampling, random and bias error. 
!
!		Note: The SST, SST ANOMALY AND ERROR ARRAYS MUST BE MULTIPLIED BY 0.01 
!		TO CONVERT THE VALUES TO DEGREE C. The sea ice concentration array is in per cent (0-100). 
!		Missing values are -999.
!
!		All arrays consist of 1440 spatial points in longitude from 0.125E to 359.875E 
!		in intervals of 0.25 increasing eastward, and 720 spatial points in latitude 
!		from 89.875S to 89.875N in intervals of 0.25 increasing northward.
!		
!		For more information see: ftp://eclipse.ncdc.noaa.gov/pub/OI-daily-v2/IEEE/README
!
! PROGRAM HISTORY LOG:
!   08-11-03  JORGE LUIS GOMES - read gridded SST
!   28-09-11 MELORY MONIE - read sst 0.25deg. and fill data over the land
!
      subroutine gridst(insst,gsst)
!
      parameter(nx=1440,ny=720,nxp1=nx+1)
	integer*2 sst(nx,ny),anom(nx,ny),err(nx,ny),ice(nx,ny)
	integer*4 iyr, imo, ida

      real*4 out(nx,ny),gsst(nxp1,ny)
!      dimension gsst(nxp1,ny)

!
!      OPEN UNIT FOR READING GRID FILE
       OPEN (INSST,form='unformatted',convert='big_endian')

       read (INSST) iyr,imo,ida,sst       
       read (INSST) iyr,imo,ida,anom             
       read (INSST) iyr,imo,ida,err
       read (INSST) iyr,imo,ida,ice
       read (INSST) title

              do  i=1,nx
                do  j=1,ny
                 out(i,j)=(sst(i,j)*0.01)+273.15
                enddo
              enddo

!       READ(sst)(((out(i,j)*0.01)+273.15,i=1,1440),j=1,720)


!------Over the land, the value of SST data are equal 264.16 leaving shadows at the edges,
!------so, to solve the problem we fill with neighbor's value
      DO Z=1,10
         DO I=1,nx
            DO J=1,ny
             
	    	  if (out(I,J) .eq. 263.16 .and. out(I+1,J) .ne. 263.16) then
	    	  out(I,J)=out(I+1,J)
	    	  endif
         
            ENDDO
         ENDDO
      ENDDO

      DO Z=1,10
         DO I=1,nx
            DO J=1,ny
		
		  if (out(I,J) .eq. 263.16 .and. out(I-1,J) .ne. 263.16) then
	    	  out(I,J)=out(I-1,J)
	        endif 
		  
            ENDDO
         ENDDO
      ENDDO
!---------End of Fill Data -----------!
!
              do  jj= 1,ny
                do  kk= 1,nx
                 gsst(kk,jj) = out(kk,jj)
                end do
              end do
!
!...   add greenich to right side of grid
!
             do jj = 1,ny
               gsst(nxp1,jj) = gsst(1,jj)
             end do
         write(95)gsst
!
!
   30        CONTINUE
!
  999           CONTINUE
	write(6,*) 'leaving GRIDST'
             return
             END
