      SUBROUTINE SSTHIRES (SST,SM,GLAT,GLON,IDAT,LIST,DTR)
!
      IMPLICIT REAL (A-H, O-Z)
!
      INCLUDE "parmeta"
!

!hires
	REAL INCR,ILAT1,ILON1,ILAT2,ILON2
	PARAMETER(INCR=0.25) !mel
!hires

      PARAMETER  (H90=90.0,H360=360.0,D5=5.E-1,D00=0.0,H1=1.0)
!
      INTEGER IDATE(4),IDAT(3),MONTH(12)
      DIMENSION SSTLL(1441,720),SALTLK(12),SALTLA(2),SALTLO(2) !mel
!
      DIMENSION  SST(IM,JM), SM(IM,JM), GLAT(IM,JM), GLON(IM,JM)
!
      DATA   INSST/39/
      DATA   INDXST/0/

      DATA MONTH/31,28,31,30,31,30,31,31,30,31,30,31/
!
      DATA SALTLK/273.38,274.27,278.50,283.01,287.33,293.41
     1,           297.13,297.73,294.97,289.58,282.31,275.67/
!
!     CORNERS OF SALT LAKE LATITUDE/LONGITUDE BOX
!     in degrees---> 40.0     42.0            111.0    114.0
      DATA SALTLA/0.698132,0.733038/,SALTLO/1.937315,1.989675/
!
      IOUTUPRT = LIST

!JLG 20081104 - Removed reading of sst grib. Now read a binary sst converted from sst grib2 with wgrib2
 
      CALL GRIDST(INSST,SSTLL)


!----  INTERPOLATE 0.25-DEG GLOBAL SST TO ETA GRID  -------
!
!-CP NOTE:  THIS SUBROUTINE AND INTERPOLATION ALGORITHM ASSUME
!-CP A 0.25-DEG GLOBAL SST FIELD IN THE FOLLOWING FORMAT:  
!
!	I=1 at 0.125 E, I=1440 at 359.875E, I=1441 at 0.125 E
!	J=1 at 89.875 S, J=720 at 89.875 N 
!
!	Old 1 degree data
!	I=1 AT 0.5 E,  I=2 AT 1.5 E, ... , I=360 at 0.5W
!	J=1 AT 89.5S, J=2 AT 88.5 S, ..., J=180 at 89.5N
!
!	Old 0.5 degree data
!	I=1 at 0.25 E, I=720 at 359.75E, I=721 at 0.25 E
!	J=1 at 89.75 S, J=360 at 89.75 N 
!
!-CP  
!-CP In the interpolation algorithm below, glon is positive westward,
!-CP from 0 to 360, with 0 at the greenwich meridian.  Elon is positive 
!-CP eastward, thus the need to subtract glon from 360 to get the index
!-CP of the correct oisst point.  If your input 1 deg SST field is in
!-CP a different indexing scheme, you will need to change the algorithm
!-CP below - see "grdeta.oldoi"

      DO J=1,JM
      DO I=1,IM
	
      ELAT=H90+GLAT(I,J)/DTR
      ELON=H360-GLON(I,J)/DTR

      IF(ELON.GT.H360)ELON=ELON-H360

	DIF=ELON-INT(ELON)
	
	IF (DIF .ge. 0.375) ILON1=INT(ELON)+0.375 !0.75 0.75 !mel
	IF (DIF .lt. 0.125) ILON1=INT(ELON)-0.125 !0.25 0.25 !mel
	IF (DIF .ge. 0.125 .and. DIF .lt. 0.375) ILON1=INT(ELON)+0.125 !0.25 0.75 0.25 !mel

!old      IF(ILON1.EQ.D00)ILON1=360.
      IF(ILON1.LE.D00)ILON1=360.
      ILON2=ILON1+INCR


!-MP	New approach sets ILAT1, ILON1 to point on SST grid that is
!-MP	SW of the Eta Grid point.

        DIF=ELAT-INT(ELAT)
        IF (DIF .ge. 0.375) ILAT1=INT(ELAT)+0.375 !0.75 0.75 !mel
        IF (DIF .lt. 0.125) ILAT1=INT(ELAT)-0.125 !0.25 0.25 !mel
        IF (DIF .ge. 0.125 .and. DIF .lt. 0.375) ILAT1=INT(ELAT)+0.125 !0.25 0.75 0.25 !mel


      ILAT2=ILAT1+INCR

!hires,notsure      W1=ELON-ILON1+D5
      W1=ELON-ILON1+INCR/2.
      IF(W1.LT.D00)W1=W1+H360
!hires,notsure      W2=ELAT-ILAT1+D5
      W2=ELAT-ILAT1+INCR/2.
      AR1=W1*W2
      AR2=W1*(H1-W2)
      AR3=(H1-W1)*(H1-W2)
      AR4=(H1-W1)*W2
	LON1INDX=4*(ILON1+INCR/2.) !mel alterado de 2* para 4* devido a resolucao
	LON2INDX=4*(ILON2+INCR/2.) !mel
	LAT1INDX=4*(ILAT1+INCR/2.) !mel
	LAT2INDX=4*(ILAT2+INCR/2.) !mel

	if (mod (I,20) .eq. 0 .and. mod(J,20) .eq. 0) then
	write(6,*) 'weights: ',AR1,AR2,AR3,AR4
	write(6,*) 'ILAT1,ILON1,ELAT,ELON: ', ILAT1,ILON1,ELAT,ELON
	write(6,*) '------------------------------------------'
!	write(6,*) 'corresponding indices: ', LAT1INDX,LON1INDX,
!     +					      LAT2INDX,LON2INDX
	endif

	if (LON1INDX .lt. 1 .or. LON1INDX .gt. 1441) then !721 !mel
	write(6,*) 'out of bounds on index!!', LON1INDX
	endif
	SST(I,J)=AR1*SSTLL(LON2INDX,LAT2INDX)+
     +	 	 AR2*SSTLL(LON2INDX,LAT1INDX)+
     +	 	 AR3*SSTLL(LON1INDX,LAT1INDX)+
     +	 	 AR4*SSTLL(LON1INDX,LAT2INDX)
      ENDDO
      ENDDO
!***
!***  INSERT TEMPERATURES FOR THE GREAT SALT LAKE
!***
      ID1=IDAT(1)
      ID2=IDAT(2)
      MARG0=ID1-1
      IF(MARG0.LT.1)MARG0=12
      MNTH0=MONTH(MARG0)
      MNTH1=MONTH(ID1)
      IF(ID2.LT.15)THEN
        NUMER=ID2+MNTH0-15
        DENOM=MNTH0
        IARG1=MARG0
        IARG2=ID1
      ELSE
        NUMER=ID2-15
        DENOM=MNTH1
        IARG1=ID1
        IARG2=ID1+1
        IF(IARG2.GT.12)IARG2=1
      ENDIF
      FRAC=NUMER/DENOM
      DO J=1,JM
      DO I=1,IM
        IF(GLAT(I,J).GT.SALTLA(1).AND.GLAT(I,J).LT.SALTLA(2))THEN
          IF(GLON(I,J).GT.SALTLO(1).AND.GLON(I,J).LT.SALTLO(2))THEN
            IF(SM(I,J).GT.0.5)
     1        SST(I,J)=SALTLK(IARG1)+
     2                (SALTLK(IARG2)-SALTLK(IARG1))*FRAC
          ENDIF
        ENDIF
      ENDDO
      ENDDO
C
      RETURN
C
 4500 CONTINUE
C              ERROR OCCURRED WHEN INPUTING SST FROM GRIB.
      WRITE (IOUTUPRT, 4550) INSST
 4550 FORMAT ('0', 'ERROR OCCURRED WHEN READING IN SST        ',
     1             'ON UNIT', I3, ' GRIB ' /
     2        ' ', 'EXECUTION TERMINATING.')
C
      STOP 222
C
      END
